/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.business.repository;

import br.com.sankhya.sps.business.exception.BusinessErrorCode;
import br.com.sankhya.sps.business.exception.BusinessException;
import br.com.sankhya.sps.business.exception.BusinessValidationException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import javax.validation.ConstraintViolationException;
import org.apache.log4j.Logger;

public abstract class AbstractRepository<T> {
    private static final Logger log = Logger.getLogger(AbstractRepository.class);
    @Inject
    private EntityManagerFactory entityManagerFactory;
    private Class<T> type;

    protected EntityManager getEntityManager() {
        EntityManager em = this.entityManagerFactory.createEntityManager();
        return em;
    }

    public AbstractRepository(EntityManagerFactory entityManagerFactory) {
        Type t = this.getClass().getGenericSuperclass();
        ParameterizedType pt = (ParameterizedType)t;
        this.type = (Class)pt.getActualTypeArguments()[0];
        this.entityManagerFactory = entityManagerFactory;
    }

    public T create(T t) {
        EntityManager em = this.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            em.persist(t);
            tx.commit();
        }
        catch (ConstraintViolationException e) {
            log.debug((Object)e, (Throwable)e);
            throw new BusinessValidationException(e.getConstraintViolations(), BusinessErrorCode.CONSTRAINT_VIOLATION, (Throwable)e);
        }
        catch (RuntimeException e) {
            log.debug((Object)e, (Throwable)e);
            tx.rollback();
            throw new BusinessException(BusinessErrorCode.CANNOT_SAVE, e);
        }
        finally {
            em.close();
        }
        return t;
    }

    public T update(T t) {
        EntityManager em = this.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            em.merge(t);
            tx.commit();
        }
        catch (ConstraintViolationException e) {
            throw new BusinessValidationException(e.getConstraintViolations(), BusinessErrorCode.CONSTRAINT_VIOLATION, (Throwable)e);
        }
        catch (RuntimeException e) {
            tx.rollback();
            throw new BusinessException(BusinessErrorCode.CANNOT_UPDATE, e);
        }
        finally {
            em.close();
        }
        return t;
    }

    public void delete(Object id) {
        EntityManager em = this.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        try {
            tx.begin();
            em.remove(em.getReference(this.type, id));
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            throw new BusinessException(BusinessErrorCode.CANNOT_DELETE, e);
        }
        finally {
            em.close();
        }
    }

    public T find(Object id) {
        try (EntityManager em = this.getEntityManager();){
            Object object = em.find(this.type, id);
            return (T)object;
        }
    }

    public List<T> findAll() {
        try (EntityManager em = this.getEntityManager();){
            List items;
            Query query = em.createQuery("from " + this.type.getName() + " t");
            List list = items = query.getResultList();
            return list;
        }
    }

    public long count() {
        try (EntityManager em = this.getEntityManager();){
            Query query = em.createQuery("SELECT COUNT(t) FROM " + this.type.getName() + " t");
            Long count = (Long)query.getSingleResult();
            long l = count;
            return l;
        }
    }
}

