/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.business.model;

import br.com.sankhya.sps.business.model.Job;
import br.com.sankhya.sps.enumeration.DocTaste;
import br.com.sankhya.sps.enumeration.PrinterStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterState;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

@Entity
public class Printer {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    @Length(max=300)
    @Column(name="printerName", unique=true, length=300)
    private String printerName;
    @NotNull
    @Column(name="printerStatus")
    @Enumerated(value=EnumType.STRING)
    private PrinterStatus printerStatus;
    @ElementCollection(targetClass=DocTaste.class, fetch=FetchType.EAGER)
    @Enumerated(value=EnumType.STRING)
    @CollectionTable(name="printer_doctastes")
    @Column(name="supportedDocTastes")
    private List<DocTaste> supportedDocTastes;
    @OneToMany(mappedBy="printer", fetch=FetchType.LAZY)
    private List<Job> jobs = new ArrayList<Job>();
    @Transient
    private PrintService printService;

    public static Printer buildPrinter(PrintService printService) {
        Printer printer = new Printer();
        printer.setPrinterName(printService.getName());
        PrinterIsAcceptingJobs printerIsAcceptingJobs = printService.getAttribute(PrinterIsAcceptingJobs.class);
        PrinterState printerState = printService.getAttribute(PrinterState.class);
        PrinterStatus printerStatus = PrinterStatus.valueOf((PrinterState)printerState, (PrinterIsAcceptingJobs)printerIsAcceptingJobs);
        printer.setPrinterStatus(printerStatus);
        printer.setPrintService(printService);
        DocTaste[] supportedDocTypes = Printer.getSupportedDocTypes(printService);
        printer.setSupportedDocTastes(Arrays.asList(supportedDocTypes));
        return printer;
    }

    private static DocTaste[] getSupportedDocTypes(PrintService printService) {
        DocTaste[] values = DocTaste.values();
        ArrayList<DocTaste> supportedValues = new ArrayList<DocTaste>();
        for (DocTaste docType : values) {
            if (!Printer.isSupportedDocType(docType, printService)) continue;
            supportedValues.add(docType);
        }
        return supportedValues.toArray(new DocTaste[supportedValues.size()]);
    }

    private static boolean isSupportedDocType(DocTaste docType, PrintService printService) {
        DocFlavor docFlavor;
        if (printService == null) {
            return false;
        }
        DocFlavor[] supportedDocFlavors = printService.getSupportedDocFlavors();
        if (supportedDocFlavors == null || supportedDocFlavors.length == 0) {
            return false;
        }
        List<DocFlavor> supportedDocFlavorsList = Arrays.asList(supportedDocFlavors);
        return supportedDocFlavorsList.contains(docFlavor = docType.getDefaultDocFlavor());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPrinterName() {
        return this.printerName;
    }

    public void setPrinterName(String printerName) {
        this.printerName = printerName;
    }

    public PrinterStatus getPrinterStatus() {
        return this.printerStatus;
    }

    public void setPrinterStatus(PrinterStatus printerStatus) {
        this.printerStatus = printerStatus;
    }

    public List<DocTaste> getSupportedDocTastes() {
        return this.supportedDocTastes;
    }

    public void setSupportedDocTastes(List<DocTaste> supportedDocTastes) {
        this.supportedDocTastes = supportedDocTastes;
    }

    public List<Job> getJobs() {
        return this.jobs;
    }

    public void setJobs(List<Job> jobs) {
        this.jobs = jobs;
    }

    public void addJob(Job job) {
        this.jobs.add(job);
    }

    public PrintService getPrintService() {
        return this.printService;
    }

    public void setPrintService(PrintService printService) {
        this.printService = printService;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Printer other = (Printer)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

