/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.business.model;

import br.com.sankhya.sps.business.model.Printer;
import br.com.sankhya.sps.enumeration.DocTaste;
import br.com.sankhya.sps.enumeration.DocType;
import br.com.sankhya.sps.enumeration.JobStatus;
import br.com.sankhya.sps.util.Preconditions;
import com.sankhya.util.StringUtils;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;

@Entity
public class Job {
    public static final int MAX_LIFE_TIME = 24;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotBlank
    @Column(name="description")
    private String description;
    @NotBlank
    @Column(name="userId")
    private String userId;
    @NotBlank
    @Column(name="userName")
    private String userName;
    @NotBlank
    @Column(name="clientIp")
    private String clientIp;
    @NotNull
    @Min(value=1L)
    @Column(name="copies")
    private Integer copies;
    @NotNull
    @Column(name="createdDate")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdDate;
    @Column(name="updatedDate")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date updatedDate;
    @NotNull
    @Column(name="jobStatus")
    @Enumerated(value=EnumType.STRING)
    private JobStatus jobStatus;
    @NotNull
    @Column(name="docTaste")
    @Enumerated(value=EnumType.STRING)
    private DocTaste docTaste;
    @NotNull
    @Column(name="docType")
    @Enumerated(value=EnumType.STRING)
    private DocType docType;
    @NotNull
    @ManyToOne
    @JoinColumn(name="printerId")
    private Printer printer;
    @Column(name="jobStatusMessage")
    private String jobStatusMessage;
    @NotNull
    @Column(name="fileName")
    private String fileName;
    @NotNull
    @Column(name="originalFileName")
    private String originalFileName;
    @NotNull
    @Column(name="originalFileExtension")
    private String originalFileExtension;

    public static Job createJob(Printer printer, String description, Integer copies, String userId, String userName, String clientIp, DocTaste docTaste, DocType docType, String originalFileName, String originalFileExtension) {
        Job job = new Job();
        job.printer = printer;
        printer.addJob(job);
        job.description = description;
        job.copies = copies;
        job.userId = userId;
        job.userName = userName;
        job.clientIp = clientIp;
        job.docTaste = docTaste;
        job.docType = docType;
        job.originalFileName = StringUtils.isEmpty((String)originalFileName) ? docType.toString().toLowerCase() : originalFileName;
        job.originalFileExtension = StringUtils.isEmpty((String)originalFileExtension) ? docTaste.getDefaultFileExtension() : originalFileExtension;
        job.updatedDate = job.createdDate = new Date();
        job.jobStatus = JobStatus.READY;
        job.jobStatusMessage = JobStatus.READY.getDescription();
        job.fileName = Job.buildFilename(job);
        return job;
    }

    public Job cloneJob() {
        Job newJob = Job.createJob(this.printer, this.description, this.copies, this.userId, this.userName, this.clientIp, this.docTaste, this.docType, this.originalFileName, this.originalFileExtension);
        return newJob;
    }

    private Job() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public Integer getCopies() {
        return this.copies;
    }

    public void setCopies(Integer copies) {
        this.copies = copies;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    public DocTaste getDocTaste() {
        return this.docTaste;
    }

    public void setDocTaste(DocTaste docTaste) {
        this.docTaste = docTaste;
    }

    public DocType getDocType() {
        return this.docType;
    }

    public void setDocType(DocType docType) {
        this.docType = docType;
    }

    public Printer getPrinter() {
        return this.printer;
    }

    public void setPrinter(Printer printer) {
        this.printer = printer;
    }

    public String getJobStatusMessage() {
        return this.jobStatusMessage;
    }

    public void setJobStatusMessage(String jobStatusMessage) {
        this.jobStatusMessage = jobStatusMessage;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public void setOriginalFileName(String originalFileName) {
        this.originalFileName = originalFileName;
    }

    public String getOriginalFileExtension() {
        return this.originalFileExtension;
    }

    public void setOriginalFileExtension(String originalFileExtension) {
        this.originalFileExtension = originalFileExtension;
    }

    public boolean isLifeTimeExpired() {
        DateTime createdDateTiame = new DateTime((Object)this.createdDate);
        DateTime today = new DateTime();
        Duration duration = new Duration((ReadableInstant)createdDateTiame, (ReadableInstant)today);
        long standardHours = duration.getStandardHours();
        return standardHours >= 24L;
    }

    public boolean isTimeoutToErrorExpired(int timeout) {
        DateTime createdDateTime = new DateTime((Object)this.createdDate);
        DateTime now = new DateTime();
        DateTime limit = now.minusSeconds(timeout);
        int compareTo = createdDateTime.compareTo((ReadableInstant)limit);
        return compareTo <= 0;
    }

    public boolean statusAllowReprint() {
        return this.jobStatus != JobStatus.READY && this.jobStatus != JobStatus.SENDING && this.jobStatus != JobStatus.PRINTING && this.jobStatus != JobStatus.REQUIRE_ATTENTION && this.jobStatus != JobStatus.UNKNOWN;
    }

    public static String buildFilename(Job job) {
        Preconditions.checkNotNull((Object)job.getDocTaste(), (String)"O DocTaste n\u00e3o pode ser nulo");
        Preconditions.checkNotNull((Object)job.getDocType(), (String)"O DocType n\u00e3o pode ser nulo");
        Preconditions.checkNotNull((Object)job.getOriginalFileName(), (String)"O nome do arquivo n\u00e3o pode ser nulo");
        Preconditions.checkNotNull((Object)job.getOriginalFileExtension(), (String)"A extens\u00e3o n\u00e3o pode ser nula");
        String originalFileName = job.getOriginalFileName();
        String fileExtension = job.getOriginalFileExtension();
        UUID uuid = UUID.randomUUID();
        String newFileName = String.format("%s_%s.%s", originalFileName, uuid.toString(), fileExtension);
        return newFileName;
    }

    public String toString() {
        return String.format("%d - %s\nStatus: %s | MimeType: %s | DocType: %s | Filename: %s", this.id, this.description, this.jobStatus, this.docTaste, this.docType, this.fileName);
    }
}

