/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.business.model;

import java.util.Date;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;

@Entity
public class ApiKey {
    public static final int MAX_LIFE_TIME_IN_MINUTES = 5;
    public static final long MAX_APIKEY = 5L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    @Column(name="value", unique=true)
    private String value;
    @NotNull
    @Column(name="createdDate")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdDate;

    public static ApiKey newInstance() {
        ApiKey apiKey = new ApiKey();
        UUID uuid = UUID.randomUUID();
        apiKey.createdDate = new Date();
        apiKey.value = uuid.toString();
        return apiKey;
    }

    private ApiKey() {
    }

    public Long getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiKey other = (ApiKey)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

