/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.business.exception;

import br.com.sankhya.sps.business.exception.BusinessErrorCode;
import br.com.sankhya.sps.business.exception.BusinessException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;

public class BusinessValidationException
extends BusinessException {
    private static final long serialVersionUID = -2820444320416067966L;
    private Set<ConstraintViolation<?>> constraintViolations;

    public BusinessValidationException(Set<ConstraintViolation<?>> constraintViolations, BusinessErrorCode errorCode, String message, Throwable cause) {
        super(errorCode, message, cause);
        this.constraintViolations = constraintViolations;
    }

    public BusinessValidationException(Set<ConstraintViolation<?>> constraintViolations, BusinessErrorCode errorCode, String message) {
        super(errorCode, message);
        this.constraintViolations = constraintViolations;
    }

    public BusinessValidationException(Set<ConstraintViolation<?>> constraintViolations, BusinessErrorCode errorCode, Throwable cause) {
        super(errorCode, cause);
        this.constraintViolations = constraintViolations;
    }

    public BusinessValidationException(Set<ConstraintViolation<?>> constraintViolations, BusinessErrorCode errorCode) {
        super(errorCode);
        this.constraintViolations = constraintViolations;
    }

    public BusinessValidationException(Set<ConstraintViolation<?>> constraintViolations) {
        super(BusinessErrorCode.BUSINESS_ERROR);
        this.constraintViolations = constraintViolations;
    }

    public Set<ConstraintViolation<?>> getConstraintViolations() {
        return this.constraintViolations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            void var4_8;
            s.println((Object)this);
            s.println("\t-------------------------------");
            if (this.getErrorCode() != null) {
                s.println("\t" + this.getErrorCode() + ":" + this.getErrorCode().getClass().getName());
            }
            s.println("\tProperties");
            s.println("\t\t-------------------------------");
            for (Map.Entry entry : this.getProperties().entrySet()) {
                s.println("\t\t" + entry.getKey() + "=[" + entry.getValue() + "]");
            }
            s.println("\tConstraint Violations: " + (this.constraintViolations.size() > 0));
            for (ConstraintViolation constraintViolation : this.constraintViolations) {
                s.println("\t\t-------------------------------");
                s.println("\t\tField: " + constraintViolation.getPropertyPath().toString());
                s.println("\t\tMessage: " + constraintViolation.getMessage());
                s.println();
            }
            s.println("\t-------------------------------");
            StackTraceElement[] trace = this.getStackTrace();
            boolean bl = false;
            while (var4_8 < trace.length) {
                s.println("\tat " + trace[var4_8]);
                ++var4_8;
            }
            Throwable throwable = this.getCause();
            if (throwable != null) {
                throwable.printStackTrace(s);
            }
            s.flush();
        }
    }
}

