/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps;

import br.com.sankhya.sps.business.repository.UserRepository;
import br.com.sankhya.sps.business.service.JobService;
import br.com.sankhya.sps.concurrent.PrinterQueueManager;
import br.com.sankhya.sps.concurrent.ScheduledTasksManager;
import br.com.sankhya.sps.desktop.SystemTrayMenu;
import br.com.sankhya.sps.http.WebConsole;
import br.com.sankhya.sps.initializer.CompositeInitializer;
import br.com.sankhya.sps.initializer.Initializer;
import br.com.sankhya.sps.module.BusinessModule;
import br.com.sankhya.sps.module.CommandModule;
import br.com.sankhya.sps.module.ConversionModule;
import br.com.sankhya.sps.module.PropertiesFileConfigModule;
import br.com.sankhya.sps.module.UtilsModule;
import br.com.sankhya.sps.module.ValidationModule;
import br.com.sankhya.sps.module.WebConsoleModule;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.awt.SystemTray;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class PrintServiceMain {
    private static final int DEFAULT_SHUTDOWN_TIME = 60;
    private static Logger log = Logger.getLogger(PrintServiceMain.class);
    private static PrintServiceMain instance = new PrintServiceMain();
    private WebConsole webConsole;
    private PrinterQueueManager printerQueueManager;
    private ScheduledTasksManager scheduledTasksManager;
    private SystemTrayMenu systemTrayMenu;

    public static PrintServiceMain getInstance() {
        if (instance == null) {
            instance = new PrintServiceMain();
        }
        return instance;
    }

    public static void main(String[] args) {
        try {
            log.info((Object)"Iniciando servidor de impress\u00e3o");
            PrintServiceMain serverProvider = PrintServiceMain.getInstance();
            serverProvider.start();
            log.info((Object)"Servidor de impress\u00e3o iniciado");
            while (true) {
                Thread.sleep(5000L);
            }
        }
        catch (Exception e) {
            String message = "Um erro derrubou o servidor de impress\u00e3o: " + e.getMessage();
            log.error((Object)message, (Throwable)e);
            if (SystemTray.isSupported()) {
                JOptionPane.showMessageDialog(null, message, "Erro de inicializa\u00e7\u00e3o", 0);
            }
            System.exit(1);
            return;
        }
    }

    public void start() throws Exception {
        this.start(new PropertiesFileConfigModule(), new UtilsModule(), new ConversionModule(), new BusinessModule(), new ValidationModule(), new CommandModule(), new WebConsoleModule());
    }

    public void start(AbstractModule ... abstractModules) throws Exception {
        Injector injector = this.initInjector(abstractModules);
        this.init(injector);
        this.initWebConsole(injector);
        this.initAdminUser(injector);
        this.initPrinterQueueManager(injector);
        this.initScheduledTasksManager(injector);
        this.checkUnknownJobs(injector);
        this.initSystemTrayMenu(injector);
        this.startJobsCollector(injector);
    }

    Injector initInjector(AbstractModule ... abstractModules) {
        log.info((Object)"Iniciando injetor do guice");
        Injector injector = Guice.createInjector((Module[])abstractModules);
        return injector;
    }

    void initScheduledTasksManager(Injector injector) {
        log.info((Object)"Iniciando gerenciador de tarefas agendadas");
        this.scheduledTasksManager = (ScheduledTasksManager)injector.getInstance(ScheduledTasksManager.class);
        this.scheduledTasksManager.init();
        log.info((Object)"Gerenciador de tarefas agendadas iniciado");
    }

    void initPrinterQueueManager(Injector injector) {
        log.info((Object)"Iniciando o gerenciador de filas de impress\u00e3o");
        this.printerQueueManager = (PrinterQueueManager)injector.getInstance(PrinterQueueManager.class);
        this.printerQueueManager.init();
        log.info((Object)"Gerenciador de filas de impress\u00e3o iniciado");
    }

    void initAdminUser(Injector injector) {
        log.info((Object)"Iniciando usu\u00e1rio admin");
        UserRepository userRepository = (UserRepository)injector.getInstance(UserRepository.class);
        userRepository.initAdminUser();
        log.info((Object)"Usu\u00e1rio admin iniciado");
    }

    void initWebConsole(Injector injector) {
        log.info((Object)"Iniciando o console web");
        this.webConsole = (WebConsole)injector.getInstance(WebConsole.class);
        this.webConsole.init();
        log.info((Object)"Console web iniciado");
    }

    public void checkUnknownJobs(Injector injector) {
        log.info((Object)"Iniciando tratamento de jobs com status desconhecido");
        JobService jobService = (JobService)injector.getInstance(JobService.class);
        jobService.checkUnknownJobs();
        log.info((Object)"Tratamento de jobs com status desconhecido foi finalizado");
    }

    public void init(Injector injector) throws Exception {
        Initializer initializer = (Initializer)injector.getInstance(CompositeInitializer.class);
        initializer.init();
    }

    void initSystemTrayMenu(Injector injector) throws Exception {
        log.info((Object)"Iniciando o menu da system tray");
        this.systemTrayMenu = (SystemTrayMenu)injector.getInstance(SystemTrayMenu.class);
        this.systemTrayMenu.init();
        log.info((Object)"Menu da system tray iniciado");
    }

    public void shutdown() {
        this.shutdown(60);
    }

    public void shutdown(int seconds) {
        log.info((Object)"Iniciando shutdown");
        if (this.printerQueueManager != null) {
            log.info((Object)"Shutdown do printQueueManager");
            try {
                this.printerQueueManager.shutdown(seconds);
                log.info((Object)"PrintQueueManager parado");
            }
            catch (InterruptedException e) {
                log.info((Object)"PrintQueueManager interrompido");
            }
        }
        if (this.scheduledTasksManager != null) {
            log.info((Object)"Shutdown do scheduledTasksManager");
            try {
                this.scheduledTasksManager.shutdown(seconds);
                log.info((Object)"ScheduledTasksManager parado");
            }
            catch (InterruptedException e) {
                log.info((Object)"ScheduledTasksManager  interrompido");
            }
        }
        if (this.webConsole != null) {
            log.info((Object)"Shutdown do webConsole");
            this.webConsole.shutdown();
        }
        if (this.systemTrayMenu != null) {
            this.systemTrayMenu.shutdown();
        }
        log.info((Object)"Finalizando shutdown");
    }

    public void startJobsCollector(Injector injector) {
        log.info((Object)"Iniciando o coletor de Jobs");
        JobService jobService = (JobService)injector.getInstance(JobService.class);
        jobService.startJobCollector();
        log.info((Object)"Coletor de Jobs iniciado com sucesso");
    }
}

