/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.arguments.filters;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class ImageFilter
extends FileFilter {
    public static final String[] IMAGES = new String[8];
    public boolean[] filter = new boolean[8];

    public ImageFilter() {
        for (int i = 0; i < this.filter.length; ++i) {
            this.filter[i] = true;
        }
    }

    public ImageFilter(boolean jpeg, boolean png, boolean gif, boolean bmp, boolean wmf, boolean tiff) {
        if (jpeg) {
            this.filter[0] = true;
            this.filter[1] = true;
        }
        if (png) {
            this.filter[2] = true;
        }
        if (gif) {
            this.filter[3] = true;
        }
        if (bmp) {
            this.filter[4] = true;
        }
        if (wmf) {
            this.filter[5] = true;
        }
        if (tiff) {
            this.filter[6] = true;
            this.filter[7] = true;
        }
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        for (int i = 0; i < IMAGES.length; ++i) {
            if (!this.filter[i] || !f.getName().toLowerCase().endsWith(IMAGES[i])) continue;
            return true;
        }
        return false;
    }

    public String getDescription() {
        return "Image files";
    }

    static {
        ImageFilter.IMAGES[0] = ".jpg";
        ImageFilter.IMAGES[1] = ".jpeg";
        ImageFilter.IMAGES[2] = ".png";
        ImageFilter.IMAGES[3] = ".gif";
        ImageFilter.IMAGES[4] = ".bmp";
        ImageFilter.IMAGES[5] = ".wmf";
        ImageFilter.IMAGES[6] = ".tif";
        ImageFilter.IMAGES[7] = ".tiff";
    }
}

