/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.print;

import br.com.sankhya.sps.conversion.string.JDOMElementToStringConverter;
import br.com.sankhya.sps.enumeration.DocType;
import br.com.sankhya.sps.enumeration.PrinterStatus;
import br.com.sankhya.sps.http.ServiceConnection;
import br.com.sankhya.sps.http.ServiceRequest;
import br.com.sankhya.sps.print.PrintRequestData;
import br.com.sankhya.sps.print.PrintServerLocation;
import br.com.sankhya.sps.print.PrinterLocation;
import br.com.sankhya.sps.print.exception.PrintErrorCode;
import br.com.sankhya.sps.print.exception.PrintException;
import com.sankhya.util.XMLUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.jdom.Document;
import org.jdom.Element;

public class PrintServiceFacade {
    private static final String PRINT_SERVER_APPLLICATION_PATH = "/aplicacao.app";
    private ServiceConnection serviceConnection;

    public PrintServiceFacade() {
        this(false);
    }

    public PrintServiceFacade(boolean printRequestAndResponse) {
        this.serviceConnection = new ServiceConnection(printRequestAndResponse);
    }

    public void setServiceConnection(ServiceConnection serviceConnection) {
        this.serviceConnection = serviceConnection;
    }

    @Deprecated
    public void print(PrintRequestData printRequestData) throws PrintException {
        this.sendPrint(printRequestData);
    }

    public String sendPrint(PrintRequestData printRequestData) throws PrintException {
        if (printRequestData == null || !printRequestData.isValid()) {
            throw new PrintException("Dados inv\u00e1lidos para executar a impress\u00e3o");
        }
        try {
            ServiceRequest request = this.createPrintServiceRequest(printRequestData);
            Document result = this.serviceConnection.secureConnect(request, Document.class);
            Element rootNode = result.getRootElement();
            Element errorReportElement = rootNode.getChild("errorReport");
            if (errorReportElement != null) {
                Element errorElement = errorReportElement.getChild("error");
                String errorMessage = XMLUtils.getContentChildAsString((Element)errorElement, (String)"errorMessage");
                throw new PrintException(PrintErrorCode.PRINT_ERROR, errorMessage);
            }
            Element printReportElement = rootNode.getChild("printReport");
            if (printReportElement == null) {
                throw new PrintException("O resultado retornado pelo Print Service indica que a impress\u00e3o n\u00e3o foi bem sucedida");
            }
            Element jobIdElement = printReportElement.getChild("jobId");
            if (jobIdElement == null) {
                throw new PrintException("O resultado retornado pelo Print Service indica que a impress\u00e3o n\u00e3o foi bem sucedida");
            }
            return jobIdElement.getText();
        }
        catch (IOException e) {
            throw new PrintException(PrintErrorCode.CANNOT_CONNECT_TO_PRINT_SERVICE, (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new PrintException(PrintErrorCode.CANNOT_CREATE_CALL_TO_PRINT_SERVICE, (Throwable)e);
        }
    }

    protected ServiceRequest createPrintServiceRequest(PrintRequestData printRequestData) {
        PrinterLocation printerLocation = printRequestData.getPrinterLocation();
        String host = printerLocation.getHost();
        int port = printerLocation.getPort();
        ServiceRequest request = new ServiceRequest(host, port, PRINT_SERVER_APPLLICATION_PATH);
        byte[] document = printRequestData.getDocument();
        String contentType = printRequestData.getContentType();
        String printerName = printerLocation.getPrinterName();
        String jobDescription = printRequestData.getJobDescription();
        String string = printRequestData.getDocTaste().toString();
        BigDecimal userId = printRequestData.getUserId();
        String userName = printRequestData.getUserName();
        int copies = printRequestData.getCopies();
        DocType docType = printRequestData.getDocType();
        request.setContent(document, contentType);
        request.addParam("serviceName", "print");
        request.addParam("printerName", printerName);
        request.addParam("jobDescription", jobDescription);
        request.addParam("mimeType", string);
        request.addParam("userId", userId.toString());
        request.addParam("userName", userName);
        request.addParam("copies", String.valueOf(copies));
        request.addParam("docType", docType.toString());
        return request;
    }

    public Element getPrinterListFromServer(String host, int port) throws PrintException {
        ServiceRequest request = new ServiceRequest(host, port, PRINT_SERVER_APPLLICATION_PATH);
        request.addParam("serviceName", "listprinters");
        try {
            Document document = this.serviceConnection.secureConnect(request, Document.class);
            Element rootElement = document.getRootElement();
            Element errorReport = rootElement.getChild("errorReport");
            if (errorReport != null) {
                Element error = errorReport.getChild("error");
                throw new PrintException(PrintErrorCode.PRINT_ERROR, error.getText());
            }
            Element impressorasElement = rootElement.getChild("impressoras");
            Element detached = (Element)impressorasElement.detach();
            return detached;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            String errorMessage = String.format("%s: Host desconhecido: %s", PrintErrorCode.CANNOT_CONNECT_TO_PRINT_SERVICE.getDefaultMessage(), e.getMessage());
            throw new PrintException(PrintErrorCode.CANNOT_CONNECT_TO_PRINT_SERVICE, errorMessage);
        }
        catch (IOException e) {
            String errorMessage = String.format("%s: %s", PrintErrorCode.CANNOT_CONNECT_TO_PRINT_SERVICE.getDefaultMessage(), e.getMessage());
            throw new PrintException(PrintErrorCode.CANNOT_CONNECT_TO_PRINT_SERVICE, errorMessage, e);
        }
        catch (URISyntaxException e) {
            String errorMessage = String.format("%s: %s", PrintErrorCode.CANNOT_CONNECT_TO_PRINT_SERVICE.getDefaultMessage(), e.getMessage());
            throw new PrintException(PrintErrorCode.CANNOT_CREATE_CALL_TO_PRINT_SERVICE, errorMessage, e);
        }
    }

    public Element getJobStatus(PrintServerLocation printServerLocation, String jobId) {
        ServiceRequest request = new ServiceRequest(printServerLocation, PRINT_SERVER_APPLLICATION_PATH);
        request.addParam("serviceName", "jobstatus");
        request.addParam("jobId", jobId);
        try {
            Document document = this.serviceConnection.secureConnect(request, Document.class);
            Element rootElement = document.getRootElement();
            JDOMElementToStringConverter converter = new JDOMElementToStringConverter();
            String convert = converter.convert(rootElement);
            System.out.println(convert);
            Element errorReport = rootElement.getChild("errorReport");
            if (errorReport != null) {
                Element error = errorReport.getChild("error");
                Element errorMessage = error.getChild("errorMessage");
                throw new PrintException(PrintErrorCode.PRINT_ERROR, errorMessage.getText());
            }
            Element noJobs = rootElement.getChild("nojobs");
            Element detached = null;
            if (noJobs != null) {
                return null;
            }
            Element jobStatusElement = rootElement.getChild("job");
            detached = (Element)jobStatusElement.detach();
            return detached;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            String errorMessage = String.format("%s: Host desconhecido: %s", PrintErrorCode.CANNOT_CONNECT_TO_PRINT_SERVICE.getDefaultMessage(), e.getMessage());
            throw new PrintException(PrintErrorCode.CANNOT_CONNECT_TO_PRINT_SERVICE, errorMessage);
        }
        catch (IOException e) {
            String errorMessage = String.format("%s: %s", PrintErrorCode.CANNOT_CONNECT_TO_PRINT_SERVICE.getDefaultMessage(), e.getMessage());
            throw new PrintException(PrintErrorCode.CANNOT_CONNECT_TO_PRINT_SERVICE, errorMessage, e);
        }
        catch (URISyntaxException e) {
            String errorMessage = String.format("%s: %s", PrintErrorCode.CANNOT_CONNECT_TO_PRINT_SERVICE.getDefaultMessage(), e.getMessage());
            throw new PrintException(PrintErrorCode.CANNOT_CREATE_CALL_TO_PRINT_SERVICE, errorMessage, e);
        }
    }

    public PrinterStatus getPrinterStatus(PrinterLocation printerLocation) {
        ServiceRequest request = new ServiceRequest(printerLocation.getHost(), printerLocation.getPort(), PRINT_SERVER_APPLLICATION_PATH);
        request.addParam("serviceName", "listprinters");
        request.addParam("printerName", printerLocation.getPrinterName());
        try {
            Document document = this.serviceConnection.secureConnect(request, Document.class);
            Element rootElement = document.getRootElement();
            Element errorReport = rootElement.getChild("errorReport");
            if (errorReport != null) {
                Element error = errorReport.getChild("error");
                throw new PrintException(PrintErrorCode.PRINT_ERROR, error.getText());
            }
            Element impressorasElement = rootElement.getChild("impressoras");
            Element impressoraElement = impressorasElement.getChild("impressora");
            Element statusElement = impressoraElement.getChild("printerStatus");
            PrinterStatus status = PrinterStatus.valueOf((String)statusElement.getText());
            return status;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            String errorMessage = String.format("%s: Host desconhecido: %s", PrintErrorCode.CANNOT_CONNECT_TO_PRINT_SERVICE.getDefaultMessage(), e.getMessage());
            throw new PrintException(PrintErrorCode.CANNOT_CONNECT_TO_PRINT_SERVICE, errorMessage);
        }
        catch (IOException e) {
            String errorMessage = String.format("%s: %s", PrintErrorCode.CANNOT_CONNECT_TO_PRINT_SERVICE.getDefaultMessage(), e.getMessage());
            throw new PrintException(PrintErrorCode.CANNOT_CONNECT_TO_PRINT_SERVICE, errorMessage, e);
        }
        catch (URISyntaxException e) {
            String errorMessage = String.format("%s: %s", PrintErrorCode.CANNOT_CONNECT_TO_PRINT_SERVICE.getDefaultMessage(), e.getMessage());
            throw new PrintException(PrintErrorCode.CANNOT_CREATE_CALL_TO_PRINT_SERVICE, errorMessage, e);
        }
        catch (Exception e) {
            String errorMessage = String.format("%s: %s", PrintErrorCode.CANNOT_CONNECT_TO_PRINT_SERVICE.getDefaultMessage(), e.getMessage());
            throw new PrintException(PrintErrorCode.CANNOT_CREATE_CALL_TO_PRINT_SERVICE, errorMessage, e);
        }
    }
}

