/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.print;

import br.com.sankhya.sps.print.PrinterLocation;
import com.sankhya.util.StringUtils;

public class DefaultPrinterLocation
implements PrinterLocation {
    private String host;
    private int port;
    private String printerName;

    public DefaultPrinterLocation(String host, int port, String printerName) {
        this.host = host;
        this.port = port;
        this.printerName = printerName;
    }

    @Override
    public boolean isValid() {
        boolean validHost = !StringUtils.isEmpty((String)this.host);
        boolean validPrinterName = !StringUtils.isEmpty((String)this.printerName);
        boolean validPort = this.port > 0;
        return validHost && validPrinterName && validPort;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getPrinterName() {
        return this.printerName;
    }

    @Override
    public String getPrinterUri() {
        return String.format("%s:%d/%s", this.host, this.port, this.printerName);
    }

    public String toString() {
        return this.getPrinterUri();
    }

    @Override
    public String getPrintServerUri() {
        return String.format("%s:%d", this.host, this.port);
    }

    @Override
    public boolean requiresAuthorization() {
        return false;
    }
}

