/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http;

import br.com.sankhya.sps.http.SpecialEncoder;
import br.com.sankhya.sps.print.PrintServerLocation;
import br.com.sankhya.sps.util.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ServiceRequest {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 9091;
    private String host;
    private int port;
    private String path;
    private SortedMap<String, String> params;
    private Map<String, String> headers;
    private byte[] content;

    public ServiceRequest(String path) {
        this(DEFAULT_HOST, 9091, path);
    }

    public ServiceRequest(PrintServerLocation printServerLocation, String path) {
        this(printServerLocation.getHost(), printServerLocation.getPort(), path);
    }

    public ServiceRequest(String host, int port, String path) {
        Preconditions.checkNotNull((Object)host, (String)"O host deve ser informado");
        Preconditions.checkNotNull((Object)path, (String)"O path deve ser informado");
        Preconditions.checkArgument((boolean)path.startsWith("/"), (String)"O caminho deve come\u00e7ar com um caracter '/'");
        this.host = host;
        this.port = port;
        this.path = path;
        this.headers = new HashMap<String, String>();
        this.params = new TreeMap<String, String>();
    }

    public String getPathAndQuery() throws URISyntaxException, UnsupportedEncodingException {
        String query = this.getEncodedQuery();
        URI uri = new URI("http", null, this.host, this.port, this.path, query, null);
        return uri.getPath() + "?" + query;
    }

    public String getQuery() {
        StringBuilder query = new StringBuilder();
        if (this.params.size() > 0) {
            int i = 1;
            for (String key : this.params.keySet()) {
                query.append(key + "=" + (String)this.params.get(key));
                if (i < this.params.keySet().size()) {
                    query.append("&");
                }
                ++i;
            }
        }
        return query.toString();
    }

    public String getEncodedQuery() throws UnsupportedEncodingException {
        StringBuilder query = new StringBuilder();
        if (this.params.size() > 0) {
            int i = 1;
            for (String key : this.params.keySet()) {
                String encoded = URLEncoder.encode((String)this.params.get(key), "UTF-8");
                encoded = SpecialEncoder.encode(encoded);
                query.append(key + "=" + encoded);
                if (i < this.params.keySet().size()) {
                    query.append("&");
                }
                ++i;
            }
        }
        return query.toString();
    }

    public String getUrl() throws URISyntaxException {
        String query = this.getQuery();
        URI uri = new URI("http", null, this.host, this.port, this.path, query, null);
        String request = uri.toASCIIString();
        return request;
    }

    public void addHeader(String headerName, String headerValue) {
        Preconditions.checkNotNull((Object)headerName, (String)"O headerName deve ser informado");
        Preconditions.checkNotNull((Object)headerValue, (String)"O headerValue deve ser informado");
        this.headers.put(headerName, headerValue);
    }

    public void addParam(String paramName, String paramValue) {
        Preconditions.checkNotNull((Object)paramName, (String)"O paramName deve ser informado");
        Preconditions.checkNotNull((Object)paramValue, (String)("O paramValue (paramName='" + paramName + "' deve ser informado"));
        this.params.put(paramName, paramValue);
    }

    public void setContent(byte[] content, String contentType) {
        this.content = content;
        this.addHeader("Content-Type", contentType);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public byte[] getContent() {
        return this.content;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public SortedMap<String, String> getParams() {
        return this.params;
    }

    public String toString() {
        return "ServiceRequest [host=" + this.host + ", port=" + this.port + ", path=" + this.path + ", params=" + this.params + ", headers=" + this.headers + ", content=" + Arrays.toString(this.content) + "]";
    }
}

