/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.sps.http;

import br.com.sankhya.sps.conversion.ConversionUtil;
import br.com.sankhya.sps.conversion.Converter;
import br.com.sankhya.sps.conversion.converter.StringToJDOMDocumentConverter;
import br.com.sankhya.sps.conversion.w3c.StringToW3CDocumentConverter;
import br.com.sankhya.sps.crypto.Encryptor;
import br.com.sankhya.sps.crypto.HmacSHA256Encriptor;
import br.com.sankhya.sps.http.ServiceRequest;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jdom.Document;
import org.jdom.Element;

public class ServiceConnection {
    private static final int DEFAULT_TIMEOUT = 20000;
    public static final String DEFAULT_SECRET_KEY = "ZmMyZWFjOTMtN2I3Ny00N2VmLWFkNGUtMmU4ZmRmYzJkYTIy";
    public static final String DEFAULT_SALT = "MzM2Yzg5YWYtZDAyYS00ODEwLWFjMzAtZWE3M2M2ZjA0MTU4";
    private ConversionUtil conversionUtil;
    protected Encryptor hmacEncryptor;
    private boolean printRequestAndResponse;

    public ServiceConnection() {
        this(false);
    }

    public ServiceConnection(boolean printRequestAndResponse) {
        this.conversionUtil = new ConversionUtil();
        this.conversionUtil.registryConverter(String.class, Document.class, (Converter)new StringToJDOMDocumentConverter());
        this.conversionUtil.registryConverter(String.class, org.w3c.dom.Document.class, (Converter)new StringToW3CDocumentConverter());
        this.hmacEncryptor = new HmacSHA256Encriptor(DEFAULT_SECRET_KEY, DEFAULT_SALT);
        this.printRequestAndResponse = printRequestAndResponse;
    }

    public ServiceConnection(ConversionUtil conversionUtil, Encryptor hmacEncryptor, boolean printRequestAndResponse) {
        this.conversionUtil = conversionUtil;
        this.hmacEncryptor = hmacEncryptor;
        this.printRequestAndResponse = printRequestAndResponse;
    }

    public ServiceConnection(ConversionUtil conversionUtil, Encryptor hmacEncryptor) {
        this(conversionUtil, hmacEncryptor, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String connect(ServiceRequest request) throws URISyntaxException, IOException {
        InputStream connectionInputStream = null;
        OutputStream outputStream = null;
        FilterOutputStream dataOutputStream = null;
        try {
            byte[] content;
            InetAddress addr = InetAddress.getLocalHost();
            String hostAddress = addr.getHostAddress();
            request.addHeader("Remote_Addr", hostAddress);
            String urlValue = request.getUrl();
            URL url = new URL(urlValue);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(20000);
            connection.setReadTimeout(20000);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setAllowUserInteraction(false);
            Map<String, String> headers = request.getHeaders();
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    connection.addRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            if ((content = request.getContent()) != null) {
                connection.setDoOutput(true);
                outputStream = connection.getOutputStream();
                dataOutputStream = new DataOutputStream(outputStream);
                dataOutputStream.write(content);
            }
            connectionInputStream = connection.getInputStream();
            String response = IOUtils.toString((InputStream)connectionInputStream);
            if (this.printRequestAndResponse) {
                System.out.println("[REQUEST] - " + connection.toString());
                System.out.println("[RESPONSE] - " + response);
            }
            String string = response;
            return string;
        }
        finally {
            if (connectionInputStream != null) {
                try {
                    connectionInputStream.close();
                }
                catch (Exception e) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception e) {}
            }
            if (dataOutputStream != null) {
                try {
                    dataOutputStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public <T> T connect(ServiceRequest request, Class<T> responsetype) throws URISyntaxException, IOException {
        String response = this.connect(request);
        return (T)this.conversionUtil.convert((Object)response, responsetype);
    }

    public String secureConnect(ServiceRequest request) throws URISyntaxException, IOException {
        String pathAndQuery = request.getPathAndQuery();
        if (this.printRequestAndResponse) {
            System.out.println("Caminho usado na autentica\u00e7\u00e3o: " + pathAndQuery);
        }
        String apiKey = this.getNewApiKey(request);
        String toEncrypt = pathAndQuery + apiKey;
        if (this.printRequestAndResponse) {
            System.out.println("Base do HMAC no cliente: " + toEncrypt);
        }
        String hmac = this.hmacEncryptor.encrypt(toEncrypt);
        request.addHeader("apiKey", apiKey);
        request.addHeader("hmac", hmac);
        return this.connect(request);
    }

    public <T> T secureConnect(ServiceRequest request, Class<T> responsetype) throws URISyntaxException, IOException {
        String response = this.secureConnect(request);
        return (T)this.conversionUtil.convert((Object)response, responsetype);
    }

    public String getNewApiKey(ServiceRequest request) throws URISyntaxException, IOException {
        String host = request.getHost();
        int port = request.getPort();
        String path = request.getPath();
        ServiceRequest apiKeyRequest = new ServiceRequest(host, port, path);
        apiKeyRequest.addParam("serviceName", "getapikey");
        String response = this.connect(apiKeyRequest);
        Document document = (Document)this.conversionUtil.convert((Object)response, Document.class);
        Element rootNode = document.getRootElement();
        Element apiKeyElement = rootNode.getChild("apiKey");
        return apiKeyElement.getText();
    }
}

