/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.barbecue;

import java.util.Arrays;
import net.sourceforge.barbecue.output.Output;
import net.sourceforge.barbecue.output.OutputException;

public class Module {
    protected final int[] bars;
    private String symbol;

    public Module(int[] nArray) {
        this.bars = nArray;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String string) {
        this.symbol = string;
    }

    public int widthInBars() {
        int n = 0;
        for (int i = 0; i < this.bars.length; ++i) {
            n += this.bars[i];
        }
        return n;
    }

    protected int draw(Output output, int n, int n2, int n3, int n4) throws OutputException {
        int n5 = 0;
        for (int i = 0; i < this.bars.length; ++i) {
            int n6 = this.bars[i];
            int n7 = n6 * n3;
            n5 += output.drawBar(n, n2, n7, n4, i % 2 == 0);
            n += n7;
        }
        return n5;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Module)) {
            return false;
        }
        Module module = (Module)object;
        return Arrays.equals(this.bars, module.bars);
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.bars.length; ++i) {
            n += (i + 1) * this.bars[i];
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.bars.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.bars[i]);
        }
        return stringBuffer.toString();
    }
}

