/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.ws;

import com.sankhya.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class ServiceContext
implements Serializable {
    public static final int STATUS_ERROR = 0;
    public static final int STATUS_OK = 1;
    public static final int STATUS_INFO = 2;
    public static final int STATUS_TIMEOUT = 3;
    public static final int STATUS_SERVICE_CANCELED = 4;
    private static ThreadLocal current = new ThreadLocal();
    private Element bodyElement;
    private Element requestBody;
    private HttpServletRequest httpRequest;
    private Map attributes;
    private Map<String, Element> clientEventsById;
    private Map httpSessionAttributes;
    private Object autentication;
    private Object responseData;
    private String statusMessage;
    private int status;
    private File tempFolder;
    private boolean retryOnError;
    private int sleepBetweenRetries = 500;
    private ByteArrayOutputStream streamedResult;

    public ServiceContext(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
        this.status = 1;
        this.bodyElement = new Element("responseBody");
        this.attributes = new HashMap();
        this.httpSessionAttributes = new HashMap();
        this.clientEventsById = new HashMap<String, Element>();
    }

    public void addClientEvent(String eventId, Element eventContent) {
        this.clientEventsById.put(eventId, eventContent);
    }

    public void reset() {
        this.clientEventsById.clear();
        this.bodyElement.removeContent();
    }

    public void setTempFolder(File f) {
        this.tempFolder = f;
    }

    public Map<String, Element> getClientEvents() {
        return this.clientEventsById;
    }

    public File getTempFolder() {
        return this.tempFolder;
    }

    public Object getRequestSessionAttribute(String name) {
        return this.httpRequest.getSession().getAttribute(name);
    }

    public Object removeRequestSessionAttribute(String name) {
        Object value = this.getRequestSessionAttribute(name);
        this.httpRequest.getSession().removeAttribute(name);
        return value;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public static ServiceContext getCurrent() {
        return (ServiceContext)current.get();
    }

    public Object getAutentication() {
        return this.autentication;
    }

    public Element getBodyElement() {
        return this.bodyElement;
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public ServletContext getServletContext() {
        return this.httpRequest.getSession().getServletContext();
    }

    public Map getHttpSessionAttributes() {
        return this.httpSessionAttributes;
    }

    public BigDecimal getParameterAsBigDecimal(String name) {
        return new BigDecimal(this.getParameterValue(name));
    }

    public Boolean getParameterAsBoolean(String name) {
        return Boolean.valueOf(this.getParameterValue(name));
    }

    public String getParameterAsString(String name) {
        return this.getParameterValue(name);
    }

    public Timestamp getParameterAsTimestamp(String name) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
            return new Timestamp(df.parse(this.getParameterValue(name)).getTime());
        }
        catch (Exception e) {
            IllegalArgumentException error = new IllegalArgumentException(e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    public Element getRequestBody() {
        if (this.requestBody == null) {
            try {
                String xmlRequestBodyAsParameter = StringUtils.getEmptyAsNull((String)this.httpRequest.getParameter("xmlRequestBody"));
                InputStream in = (InputStream)this.httpRequest.getAttribute("HttpServiceBroker.body.inputStream");
                if (in == null) {
                    in = xmlRequestBodyAsParameter == null ? this.httpRequest.getInputStream() : new ByteArrayInputStream(xmlRequestBodyAsParameter.getBytes("ISO-8859-1"));
                }
                SAXBuilder saxBuilder = new SAXBuilder();
                saxBuilder.setIgnoringElementContentWhitespace(false);
                Document doc = saxBuilder.build(in);
                this.requestBody = doc.getRootElement().getChild("requestBody");
            }
            catch (Exception e) {
                IllegalArgumentException error = new IllegalArgumentException("Erro ao processar requisi\u00e7\u00e3o HTTP. Verifique se o formato de envio \u00e9 XML.");
                error.initCause(e);
                throw error;
            }
        }
        return this.requestBody;
    }

    public Object getResponseData() {
        return this.responseData;
    }

    public String getServiceName() {
        return this.httpRequest.getParameter("serviceName");
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public boolean hasClientEvent(String eventId) {
        return this.clientEventsById.containsKey(eventId);
    }

    public boolean isParameterBlankOrNull(String name) {
        return StringUtils.getEmptyAsNull((String)this.httpRequest.getParameter(name)) == null;
    }

    public Element removeClientEvent(String eventId) {
        return this.clientEventsById.remove(eventId);
    }

    public void makeCurrent() {
        current.set(this);
    }

    public void putHttpSessionAttribute(String name, Serializable value) {
        this.httpSessionAttributes.put(name, value);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void setAutentication(Object autentication) {
        this.autentication = autentication;
    }

    public void setResponseData(Object responseData) {
        this.responseData = responseData;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public void unregistry() {
        current.set(null);
    }

    private String getParameterValue(String name) {
        if (this.isParameterBlankOrNull(name)) {
            throw new IllegalStateException("Par\u00e2metro '" + name + "' n\u00e3o informado na requisi\u00e7\u00e3o HTTP.");
        }
        return this.httpRequest.getParameter(name);
    }

    public void setRetryOnError(boolean retryOnError) {
        this.retryOnError = retryOnError;
    }

    public boolean isRetryOnError() {
        return this.retryOnError;
    }

    public int getSleepBetweenRetries() {
        return this.sleepBetweenRetries;
    }

    public void setSleepBetweenRetries(int sleepBetweenRetries) {
        this.sleepBetweenRetries = sleepBetweenRetries;
    }

    public ByteArrayOutputStream getStreamedResult() {
        return this.streamedResult;
    }

    public void setStreamedResult(ByteArrayOutputStream streamedResult) {
        this.streamedResult = streamedResult;
    }
}

