/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.ws;

import br.com.sankhya.ws.ServiceResult;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ServiceCallSerialization {
    private Object mutex = new Object();
    private Map<String, CallResult> results = new HashMap<String, CallResult>();
    private Set<String> callsOnExecution = new HashSet<String>();
    private static final long DEZ_MINUTOS = 600000L;

    public CallResult call(String callID, Caller caller, boolean waitForConcurrentCall) throws Exception {
        if (callID != null && callID.trim().length() > 0) {
            return this.serializeAndCall(callID, caller, waitForConcurrentCall);
        }
        CallResult cr = new CallResult();
        cr.resultDoc = caller.doCall();
        return cr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private CallResult serializeAndCall(String callID, Caller caller, boolean waitForConcurrentCall) throws InterruptedException, Exception {
        Object object = this.mutex;
        synchronized (object) {
            try {
                this.cleanResultCache();
                CallResult cr = null;
                if (this.callsOnExecution.contains(callID)) {
                    if (!waitForConcurrentCall) {
                        throw new IllegalConcurrentCallsExeption();
                    }
                    long waitUntil = System.currentTimeMillis() + 600000L;
                    while (!this.results.containsKey(callID)) {
                        if (System.currentTimeMillis() > waitUntil) {
                            throw new IllegalStateException("ServiceCallSerialization.serializeAndCall timeout: " + callID);
                        }
                        this.mutex.wait(1000L);
                    }
                }
                if ((cr = this.results.get(callID)) != null) {
                    if (cr.error) {
                        throw new IllegalStateException(cr.errorMessage);
                    }
                    CallResult waitUntil = cr;
                    return waitUntil;
                }
                this.callsOnExecution.add(callID);
            }
            finally {
                this.mutex.notifyAll();
            }
        }
        CallResult cr = new CallResult();
        Throwable error = null;
        try {
            cr.resultDoc = caller.doCall();
        }
        catch (Throwable e) {
            error = e;
            cr.error = true;
            cr.errorMessage = e.getMessage();
        }
        cr.dateToExpire = System.currentTimeMillis() + 600000L;
        Object e = this.mutex;
        synchronized (e) {
            this.callsOnExecution.remove(callID);
            if (waitForConcurrentCall) {
                this.results.put(callID, cr);
            }
            this.mutex.notifyAll();
        }
        if (error != null) {
            e = new IllegalStateException(error.getMessage());
            ((Throwable)e).initCause(error);
            throw e;
        }
        return cr;
    }

    private void cleanResultCache() throws Exception {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<String, CallResult>> ite = this.results.entrySet().iterator();
        while (ite.hasNext()) {
            CallResult cr = ite.next().getValue();
            if (now < cr.dateToExpire) continue;
            ite.remove();
        }
    }

    public static class IllegalConcurrentCallsExeption
    extends IllegalStateException {
    }

    public static interface Caller {
        public ServiceResult doCall() throws Exception;
    }

    public class CallResult {
        private long dateToExpire;
        private ServiceResult resultDoc;
        private boolean error;
        private String errorMessage;

        public ServiceResult getResultDocument() {
            return this.resultDoc;
        }
    }
}

