/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.ws;

import br.com.sankhya.ws.DOMServiceResult;
import br.com.sankhya.ws.ServiceAuthenticator;
import br.com.sankhya.ws.ServiceCallSerialization;
import br.com.sankhya.ws.ServiceCanceledException;
import br.com.sankhya.ws.ServiceContext;
import br.com.sankhya.ws.ServiceInvocationListener;
import br.com.sankhya.ws.ServiceResult;
import br.com.sankhya.ws.StreamedServiceResult;
import com.sankhya.util.Base64Impl;
import com.sankhya.util.ClasspathUtils;
import com.sankhya.util.CustomByteArrayOutputStream;
import com.sankhya.util.ExceptionIterator;
import com.sankhya.util.ExceptionNavigator;
import com.sankhya.util.StringUtils;
import com.sankhya.util.TimeUtils;
import com.sankhya.util.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class HttpServiceBroker
extends HttpServlet {
    public static final File SWLOG_SERVICEFOLDER = new File(System.getProperty("user.home"), "sw-logs/services");
    public static SimpleDateFormat SWSERVICECALL_DTFORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final Pattern regexCharsetEncoding = Pattern.compile("charset[\\s]*=[\\s]*([\\w0-9-]+)", 34);
    private InitialContext jndiCtx;
    private Map serviceProviders;
    private ServiceAuthenticator authenticator;
    private ServiceCallSerialization serviceCallSerialization;
    private static Object logMock = new Object();
    private Runnable cleanUpTask;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.serviceProviders = new HashMap();
        try {
            this.jndiCtx = new InitialContext();
            this.serviceCallSerialization = new ServiceCallSerialization();
            String serviceProvidersDescriptor = StringUtils.getEmptyAsNull((String)config.getInitParameter("service-providers"));
            if (serviceProvidersDescriptor == null) {
                throw new IllegalArgumentException("Parametro 'service-providers' deve ser informado na declara\u00e7\u00e3o do Servlet '" + config.getServletName() + "'");
            }
            InputStream is = config.getServletContext().getResourceAsStream(serviceProvidersDescriptor);
            if (is == null) {
                throw new IllegalArgumentException("Imposs\u00edvel localizar o descritor de service providers '" + serviceProvidersDescriptor + "' para o Servlet '" + config.getServletName() + "'");
            }
            SAXBuilder saxBuilder = new SAXBuilder();
            Document doc = saxBuilder.build(is);
            Element rootElem = doc.getRootElement();
            final String authenticatorClassName = StringUtils.getEmptyAsNull((String)rootElem.getAttributeValue("authenticator"));
            if (authenticatorClassName != null) {
                this.authenticator = (ServiceAuthenticator)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{ServiceAuthenticator.class}, new InvocationHandler(){
                    ServiceAuthenticator delegate;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        1 var4_4 = this;
                        synchronized (var4_4) {
                            if (this.delegate == null) {
                                this.delegate = (ServiceAuthenticator)ClasspathUtils.getClassFromContextClassLoader((String)authenticatorClassName).newInstance();
                            }
                        }
                        return method.invoke((Object)this.delegate, args);
                    }
                });
            }
            Element providers = rootElem.getChild("providers");
            List providersList = providers.getChildren("provider");
            for (Element provider : providersList) {
                String className = provider.getAttributeValue("class");
                String serviceName = provider.getAttributeValue("service-name");
                String invocationListenerName = provider.getAttributeValue("invocation-listener");
                boolean requiredAuthentication = true;
                String attAuth = StringUtils.getEmptyAsNull((String)provider.getAttributeValue("authentication"));
                if (attAuth != null) {
                    requiredAuthentication = Boolean.valueOf(attAuth);
                }
                ServiceProviderProxy proxy = new ServiceProviderProxy(className, requiredAuthentication, invocationListenerName);
                String type = StringUtils.getEmptyAsNull((String)provider.getAttributeValue("type"));
                proxy.type = type != null ? type : "pojo";
                proxy.jndi = StringUtils.getEmptyAsNull((String)provider.getAttributeValue("jndi"));
                proxy.serviceName = serviceName;
                String domain = StringUtils.getEmptyAsNull((String)provider.getAttributeValue("domain"));
                String nomeProvider = domain != null ? domain : className;
                this.serviceProviders.put(nomeProvider, proxy);
                config.getServletContext().log("'" + className + "' registrado como ServiceProvider '" + nomeProvider + "'.");
            }
            this.setupCleanUp();
            this.limpaCacheJasperReport();
        }
        catch (Exception e) {
            config.getServletContext().log("Erro ao inicializar HttpServiceBroker: " + e.getMessage());
            e.printStackTrace();
            config.getServletContext().log(e.getMessage());
        }
    }

    private void setupCleanUp() {
        try {
            Class cleanUpTaskClass = ClasspathUtils.getClassFromContextClassLoader((String)"br.com.sankhya.servicebroker.CleanupTask");
            if (cleanUpTaskClass != null) {
                this.log("CleanUp class:" + cleanUpTaskClass.getCanonicalName());
                this.cleanUpTask = (Runnable)cleanUpTaskClass.newInstance();
            } else {
                this.log("Nenhuma CleanUp class encontrada");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void notifyCleanUp() {
        if (this.cleanUpTask != null) {
            try {
                this.cleanUpTask.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Matcher mCharset;
        String callID = StringUtils.getEmptyAsNull((String)req.getParameter("callID"));
        String charsetEncoding = "ISO-8859-1";
        if (req.getContentType() != null && (mCharset = regexCharsetEncoding.matcher(req.getContentType())).find()) {
            charsetEncoding = mCharset.group(1);
        }
        long callStart = System.currentTimeMillis();
        String serviceName = StringUtils.getEmptyAsNull((String)req.getParameter("serviceName"));
        ServiceResult resultDoc = this.callService(req, resp, callID);
        boolean omitDeclaration = false;
        if ("text".equals(req.getParameter("outputType"))) {
            omitDeclaration = true;
            resp.setContentType("text/plain");
        } else {
            resp.setContentType("text/xml; charset=" + charsetEncoding);
        }
        resp.setDateHeader("max-age", 0L);
        resp.setStatus(200);
        ServletOutputStream out = resp.getOutputStream();
        resultDoc.writeXMLTo((OutputStream)out, charsetEncoding, omitDeclaration);
        out.flush();
        this.writeLog(callStart, serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLog(long callStart, String serviceName) {
        if (Boolean.getBoolean("servicecall.log") && serviceName != null) {
            Object object = logMock;
            synchronized (object) {
                try {
                    File f;
                    String fileName = "sw-servicecall-" + SWSERVICECALL_DTFORMAT.format(new Date()) + ".log";
                    if (!SWLOG_SERVICEFOLDER.exists()) {
                        SWLOG_SERVICEFOLDER.mkdirs();
                    }
                    if (!(f = new File(SWLOG_SERVICEFOLDER, fileName)).exists()) {
                        f.createNewFile();
                    }
                    String line = serviceName + ";" + callStart + ";" + (System.currentTimeMillis() - callStart) + "\n";
                    FileWriter fw = new FileWriter(f, true);
                    fw.write(line);
                    fw.flush();
                    fw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private ServiceResult callService(final HttpServletRequest req, HttpServletResponse resp, String callID) {
        try {
            boolean waitForConcurrentCalls = true;
            if (callID == null || callID.trim().length() == 0) {
                String allowConcurrentCalls = req.getParameter("allowConcurrentCalls");
                String string = allowConcurrentCalls = allowConcurrentCalls == null ? "false" : allowConcurrentCalls;
                if (!Boolean.valueOf(allowConcurrentCalls).booleanValue()) {
                    callID = this.buildCallID(req);
                    waitForConcurrentCalls = false;
                }
            }
            ServiceCallSerialization.CallResult cr = this.serviceCallSerialization.call(callID, new ServiceCallSerialization.Caller(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ServiceResult doCall() throws Exception {
                    int status = 0;
                    String statusMessage = null;
                    Element responseBody = null;
                    Map<String, Element> clientEventsById = null;
                    String serviceName = StringUtils.getEmptyAsNull((String)req.getParameter("serviceName"));
                    ServiceContext ctx = null;
                    try {
                        try {
                            if (serviceName == null) {
                                throw new Exception("HttpServiceBroker: O nome do servi\u00e7o \u00e9 obrigat\u00f3rio.");
                            }
                            if ("HttpServiceBroker.getSessionId".equals(serviceName)) {
                                Cookie[] c = req.getCookies();
                                String sessionId = req.getSession().getId();
                                for (int i = 0; i < c.length; ++i) {
                                    if (!c[i].getValue().equals(sessionId)) continue;
                                    responseBody = new Element("sessionCookie");
                                    responseBody.setAttribute("name", c[i].getName());
                                    responseBody.setAttribute("value", c[i].getValue());
                                    status = 1;
                                    break;
                                }
                            }
                            if ("HttpServiceBroker.getDate".equals(serviceName)) {
                                responseBody = new Element("date");
                                responseBody.setAttribute("value", TimeUtils.getNow((String)"dd/MM/yyyy"));
                                status = 1;
                            }
                            if (responseBody == null) {
                                int index = serviceName.lastIndexOf(".");
                                if (index < 0) {
                                    throw new IllegalArgumentException("Nome do dominio deve ser informado!");
                                }
                                String methodName = serviceName.substring(index + 1);
                                String className = serviceName.substring(0, index);
                                ServiceProviderProxy provider = (ServiceProviderProxy)HttpServiceBroker.this.serviceProviders.get(className);
                                if (provider == null) {
                                    throw new Exception("HttpServiceBroker: Nenhum provedor foi encontrado para o servi\u00e7o '" + serviceName + "'.");
                                }
                                if (HttpServiceBroker.this.authenticator != null) {
                                    String resourceId = StringUtils.getEmptyAsNull((String)req.getParameter("resourceID"));
                                    boolean validateSasSession = "1".equals(StringUtils.getEmptyAsNull((String)req.getParameter("vss")));
                                    if (validateSasSession && resourceId != null && !HttpServiceBroker.this.authenticator.checkValidity(resourceId, req.getSession().getId())) {
                                        Exception e = new Exception("Sess\u00e3o com SAS inv\u00e1lida: " + req.getSession().getId() + " Recurso: " + resourceId);
                                        e.initCause(new Exception("A sess\u00e3o com o servi\u00e7o de autentica\u00e7\u00e3o da licen\u00e7a expirou ou \u00e9 inv\u00e1lida.\nTente abrir esta tela novamente.\nObs: Dados n\u00e3o salvos podem ter sido perdidos."));
                                        throw e;
                                    }
                                }
                                ctx = new ServiceContext(req);
                                ctx.setTempFolder((File)HttpServiceBroker.this.getServletContext().getAttribute("javax.servlet.context.tempdir"));
                                ctx.makeCurrent();
                                boolean canExecute = true;
                                if (provider.requiresAuthentication) {
                                    if (HttpServiceBroker.this.authenticator == null) {
                                        throw new Exception("O servi\u00e7o '" + serviceName + "' requer autentica\u00e7\u00e3o, mas n\u00e3o existe um autenticador configurado para este HttpServiceBroker. Verifique o arquivo de configura\u00e7\u00f5es.");
                                    }
                                    if (!HttpServiceBroker.this.authenticator.isAuthenticated(ctx)) {
                                        status = 3;
                                        statusMessage = "N\u00e3o autorizado.";
                                        canExecute = false;
                                    } else {
                                        HttpServiceBroker.this.authenticator.setupContext(ctx);
                                    }
                                }
                                if (canExecute) {
                                    int retryCounter = 0;
                                    while (true) {
                                        try {
                                            ctx.setRetryOnError(false);
                                            provider.execute(ctx, methodName);
                                        }
                                        catch (Throwable e) {
                                            if (ctx.isRetryOnError() && retryCounter < 10) {
                                                Thread.sleep(ctx.getSleepBetweenRetries());
                                                ++retryCounter;
                                                continue;
                                            }
                                            throw e;
                                        }
                                        break;
                                    }
                                    status = ctx.getStatus();
                                    statusMessage = ctx.getStatusMessage();
                                    responseBody = ctx.getBodyElement();
                                }
                            }
                        }
                        catch (Throwable e) {
                            e = ExceptionIterator.iterate((Throwable)e, (ExceptionIterator.CauseIterator)new ExceptionIterator.CauseIterator(){

                                public boolean onNextCause(Throwable cause) {
                                    return cause instanceof ServiceCanceledException;
                                }
                            });
                            if (e instanceof ServiceCanceledException) {
                                if (((ServiceCanceledException)e).isNormalResult()) {
                                    status = ctx.getStatus();
                                    statusMessage = ctx.getStatusMessage();
                                    responseBody = ctx.getBodyElement();
                                } else {
                                    status = 4;
                                }
                            }
                            String applicationName = StringUtils.getEmptyAsNull((String)req.getParameter("application"));
                            if (applicationName == null) {
                                applicationName = "<APLICA\u00c7\u00c3O_DESCONHECIDA>";
                            }
                            System.out.println(String.format("[HTTPServiceBroker] Erro ao executar o servi\u00e7o \"%s\" chamado pela aplica\u00e7\u00e3o \"%s\".", serviceName, applicationName));
                            Element requestBody = null;
                            if (ctx != null) {
                                try {
                                    requestBody = ctx.getRequestBody();
                                }
                                catch (Exception ignored) {
                                    // empty catch block
                                }
                            }
                            if (requestBody != null) {
                                XMLUtils.printFromDebug((Element)requestBody);
                            }
                            e.printStackTrace();
                            status = 0;
                            String msg = ExceptionNavigator.getLastNotEmptyMessage((Throwable)e);
                            statusMessage = msg != null ? msg.trim() : e.getClass().getName();
                        }
                        boolean buildResultAsDOM = true;
                        ServiceResult result = null;
                        if (ctx != null && status != 0) {
                            if (ctx.getStreamedResult() != null) {
                                result = new StreamedServiceResult(ctx.getStreamedResult());
                                buildResultAsDOM = false;
                            } else {
                                clientEventsById = ctx.getClientEvents();
                            }
                        }
                        if (buildResultAsDOM) {
                            DOMServiceResult doc = new DOMServiceResult();
                            Element rootElement = new Element("serviceResponse");
                            doc.addContent((Content)rootElement);
                            rootElement.setAttribute("serviceName", serviceName == null ? "unknown" : serviceName);
                            rootElement.setAttribute("status", String.valueOf(status));
                            if (statusMessage != null) {
                                CDATA cdata = HttpServiceBroker.this.buildCData(statusMessage);
                                Element statusMessageElement = new Element("statusMessage");
                                statusMessageElement.addContent((Content)cdata);
                                rootElement.addContent((Content)statusMessageElement);
                            }
                            if (responseBody != null) {
                                rootElement.addContent((Content)responseBody);
                            }
                            if (clientEventsById != null && !clientEventsById.isEmpty()) {
                                Element clientEventsElement = new Element("clientEvents");
                                for (Map.Entry<String, Element> entry : clientEventsById.entrySet()) {
                                    Element clientEventElement = new Element("clientEvent");
                                    clientEventElement.setAttribute("id", entry.getKey());
                                    if (entry.getValue() != null) {
                                        clientEventElement.addContent((Content)entry.getValue());
                                    }
                                    clientEventsElement.addContent((Content)clientEventElement);
                                }
                                rootElement.addContent((Content)clientEventsElement);
                            }
                            result = doc;
                        }
                        StreamedServiceResult streamedServiceResult = result;
                        return streamedServiceResult;
                    }
                    finally {
                        if (HttpServiceBroker.this.authenticator != null) {
                            HttpServiceBroker.this.authenticator.clearContext();
                        }
                        if (ctx != null) {
                            ctx.unregistry();
                        }
                    }
                }
            }, waitForConcurrentCalls);
            ServiceResult serviceResult = cr.getResultDocument();
            return serviceResult;
        }
        catch (ServiceCallSerialization.IllegalConcurrentCallsExeption e) {
            String serviceName = StringUtils.getEmptyAsNull((String)req.getParameter("serviceName"));
            DOMServiceResult resultDoc = new DOMServiceResult();
            Element rootElement = new Element("serviceResponse");
            rootElement.setAttribute("serviceName", serviceName == null ? "unknown" : serviceName);
            rootElement.setAttribute("status", String.valueOf(4));
            Element statusMessageElement = new Element("statusMessage");
            statusMessageElement.addContent((Content)this.buildCData("O servi\u00e7o foi cancelado por situa\u00e7\u00e3o de concorr\u00eancia. Essa mesma sess\u00e3o HTTP fez a requisi\u00e7\u00e3o duas vezes simultaneamente."));
            rootElement.addContent((Content)statusMessageElement);
            resultDoc.addContent((Content)rootElement);
            DOMServiceResult dOMServiceResult = resultDoc;
            return dOMServiceResult;
        }
        catch (Exception e) {
            IllegalStateException error = new IllegalStateException();
            error.initCause(e);
            throw error;
        }
        finally {
            this.notifyCleanUp();
        }
    }

    private String buildCallID(HttpServletRequest req) throws Exception {
        int count;
        String serviceName = StringUtils.getEmptyAsNull((String)req.getParameter("serviceName"));
        String xmlRequestBodyAsParameter = StringUtils.getEmptyAsNull((String)req.getParameter("xmlRequestBody"));
        Object in = null;
        in = xmlRequestBodyAsParameter == null ? req.getInputStream() : new ByteArrayInputStream(xmlRequestBodyAsParameter.getBytes("ISO-8859-1"));
        CustomByteArrayOutputStream out = new CustomByteArrayOutputStream();
        byte[] buf = new byte[512];
        while ((count = ((InputStream)in).read(buf)) > 0) {
            out.write(buf, 0, count);
        }
        out.flush();
        out.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(out.getInternalBuffer(), 0, out.size());
        req.setAttribute("HttpServiceBroker.body.inputStream", (Object)bin);
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(out.getInternalBuffer(), 0, out.size());
        return serviceName + "::" + req.getSession().getId() + "::" + StringUtils.toHexString((byte[])md5.digest());
    }

    private CDATA buildCData(String msg) {
        try {
            return new CDATA(Base64Impl.encode((byte[])msg.getBytes("ISO-8859-1")));
        }
        catch (Exception e) {
            IllegalStateException error = new IllegalStateException();
            error.initCause(e);
            throw error;
        }
    }

    private Object getHomeInterface(String localHome) throws Exception {
        return this.jndiCtx.lookup(localHome);
    }

    private void limpaCacheJasperReport() {
        File tempDir = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
        File[] jaspers = tempDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(".JASPERREPORT");
            }
        });
        for (int i = 0; i < jaspers.length; ++i) {
            jaspers[i].delete();
        }
    }

    private class ServiceProviderProxy {
        Map cacheMethods;
        Method createMethod;
        Method removeMethod = null;
        Object delegateInstance;
        ServiceInvocationListener serviceInvocationListener;
        String jndi;
        String providerClassName;
        String serviceInvocationListenerName;
        String serviceName;
        String type;
        boolean requiresAuthentication;

        public ServiceProviderProxy(String providerClassName, boolean requiresAuthentication, String serviceInvocationListenerName) {
            this.providerClassName = providerClassName;
            this.requiresAuthentication = requiresAuthentication;
            this.cacheMethods = new HashMap();
            this.serviceInvocationListenerName = serviceInvocationListenerName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(ServiceContext ctx, String methodName) throws Throwable {
            Object instanceInvocator = null;
            ServiceProviderProxy serviceProviderProxy = this;
            synchronized (serviceProviderProxy) {
                if ("pojo".equals(this.type)) {
                    if (this.delegateInstance == null) {
                        this.delegateInstance = ClasspathUtils.getClassFromContextClassLoader((String)this.providerClassName).newInstance();
                        this.initializeMethods(this.delegateInstance);
                    }
                    instanceInvocator = this.delegateInstance;
                } else if ("ejb-stateless".equals(this.type)) {
                    if (this.delegateInstance == null) {
                        if (this.jndi == null) {
                            throw new IllegalArgumentException("para o tipo " + this.type + " o atributo jndi \u00e9 obrigat\u00f3rio. Provider: " + this.providerClassName);
                        }
                        this.delegateInstance = HttpServiceBroker.this.getHomeInterface(this.jndi);
                        this.createMethod = this.delegateInstance.getClass().getDeclaredMethod("create", null);
                        Object beanCreate = this.createMethod.invoke(this.delegateInstance, null);
                        this.initializeMethods(beanCreate);
                        this.removeMethod = beanCreate.getClass().getDeclaredMethod("remove", null);
                        this.removeMethod.invoke(beanCreate, null);
                    }
                    instanceInvocator = this.createMethod.invoke(this.delegateInstance, null);
                } else {
                    throw new IllegalArgumentException("Tipo de execu\u00e7\u00e3o desconhecido utilize type='pojo' ou type='ejb-stateless|statefull'");
                }
            }
            Method method = (Method)this.cacheMethods.get(methodName);
            if (method == null) {
                throw new IllegalArgumentException("M\u00e9todo " + methodName + " n\u00e3o encontrado na classe " + this.providerClassName + " ou n\u00e3o atende a especifica\u00e7\u00e3o nomeMetodo(ServiceContext)");
            }
            try {
                this.beforeExecute(ctx);
                method.invoke(instanceInvocator, ctx);
                Map sessionAttributes = ctx.getHttpSessionAttributes();
                if (!sessionAttributes.isEmpty()) {
                    HttpSession session = ctx.getHttpRequest().getSession();
                    for (Map.Entry entry : sessionAttributes.entrySet()) {
                        session.setAttribute((String)entry.getKey(), entry.getValue());
                    }
                }
                this.afterExecute(ctx);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            finally {
                this.executeClean(ctx);
            }
            if (this.removeMethod != null) {
                this.removeMethod.invoke(instanceInvocator, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void afterExecute(ServiceContext ctx) throws Exception {
            if (this.serviceInvocationListenerName != null) {
                ServiceProviderProxy serviceProviderProxy = this;
                synchronized (serviceProviderProxy) {
                    if (this.serviceInvocationListener == null) {
                        this.serviceInvocationListener = (ServiceInvocationListener)ClasspathUtils.getClassFromContextClassLoader((String)this.serviceInvocationListenerName).newInstance();
                    }
                }
                this.serviceInvocationListener.afterExecute(ctx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeClean(ServiceContext ctx) throws Exception {
            if (this.serviceInvocationListenerName != null) {
                ServiceProviderProxy serviceProviderProxy = this;
                synchronized (serviceProviderProxy) {
                    if (this.serviceInvocationListener == null) {
                        this.serviceInvocationListener = (ServiceInvocationListener)ClasspathUtils.getClassFromContextClassLoader((String)this.serviceInvocationListenerName).newInstance();
                    }
                }
                this.serviceInvocationListener.clean(ctx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void beforeExecute(ServiceContext ctx) throws Exception {
            if (this.serviceInvocationListenerName != null) {
                ServiceProviderProxy serviceProviderProxy = this;
                synchronized (serviceProviderProxy) {
                    if (this.serviceInvocationListener == null) {
                        this.serviceInvocationListener = (ServiceInvocationListener)ClasspathUtils.getClassFromContextClassLoader((String)this.serviceInvocationListenerName).newInstance();
                    }
                }
                this.serviceInvocationListener.beforeExecute(ctx);
            }
        }

        private void initializeMethods(Object obj) throws Exception {
            Class<?> cl = obj.getClass();
            Method[] method = cl.getDeclaredMethods();
            for (int i = 0; i < method.length; ++i) {
                Method m = method[i];
                Class<?>[] parameterTypes = m.getParameterTypes();
                if (this.serviceName == null) {
                    if (parameterTypes.length != 1 || parameterTypes[0] != ServiceContext.class) continue;
                    this.cacheMethods.put(m.getName(), m);
                    continue;
                }
                if (!this.serviceName.equals(m.getName()) || parameterTypes.length != 1 || parameterTypes[0] != ServiceContext.class) continue;
                this.cacheMethods.put(m.getName(), m);
                break;
            }
        }
    }
}

