/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.ws;

import br.com.sankhya.ws.GZIPResponseStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class GZIPResponseWrapper
extends HttpServletResponseWrapper {
    private HttpServletResponse origResponse = null;
    private ServletOutputStream stream = null;
    private PrintWriter writer = null;
    private boolean debug;
    private int minimumSize;
    private static ThreadLocal current = new ThreadLocal();
    private RequestListener listener;

    public GZIPResponseWrapper(HttpServletResponse response, boolean debug, int minimumSize) {
        super(response);
        this.origResponse = response;
        this.debug = debug;
        this.minimumSize = minimumSize;
        current.set(this);
    }

    public void clean() {
        current.set(null);
    }

    public ServletOutputStream createOutputStream() throws IOException {
        return new GZIPResponseStream(this.origResponse, this.debug, this.minimumSize, this);
    }

    public void finishResponse() {
        try {
            if (this.writer != null) {
                this.writer.close();
            } else if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flushBuffer() throws IOException {
        this.stream.flush();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called!");
        }
        if (this.stream == null) {
            this.stream = this.createOutputStream();
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("getOutputStream() has already been called!");
        }
        this.stream = this.createOutputStream();
        this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.stream, "UTF-8"));
        return this.writer;
    }

    public void setContentLength(int length) {
    }

    public static void registryRequestListener(RequestListener rl) {
        GZIPResponseWrapper instance = (GZIPResponseWrapper)((Object)current.get());
        if (instance != null) {
            instance.listener = rl;
        }
    }

    public RequestListener getRequestListener() {
        return this.listener;
    }

    public static interface RequestListener {
        public void afterCommitResponse(int var1);
    }
}

