/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.ws;

import br.com.sankhya.ws.GZIPResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class GZIPResponseStream
extends ServletOutputStream {
    protected ByteArrayOutputStream baos = null;
    protected GZIPOutputStream gzipstream = null;
    protected boolean closed = false;
    protected HttpServletResponse response = null;
    protected ServletOutputStream output = null;
    private boolean debug;
    private long origSize = 0L;
    private int minimumSize;
    private ByteArrayOutputStream initialBuffer;
    private GZIPResponseWrapper gzipResponseWrapper;

    public GZIPResponseStream(HttpServletResponse response, boolean debug, int minimumSize, GZIPResponseWrapper gzipResponseWrapper) throws IOException {
        this.response = response;
        this.output = response.getOutputStream();
        this.debug = debug;
        this.minimumSize = minimumSize;
        this.initialBuffer = new ByteArrayOutputStream(minimumSize);
        this.gzipResponseWrapper = gzipResponseWrapper;
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("This output stream has already been closed");
        }
        if (this.gzipstream != null) {
            this.gzipstream.finish();
        }
        boolean compressed = this.initialBuffer == null;
        byte[] bytes = null;
        bytes = compressed ? this.baos.toByteArray() : this.initialBuffer.toByteArray();
        if (this.debug) {
            if (compressed) {
                System.out.println("Closing stream.  (original: " + this.origSize + " bytes, compressed: " + bytes.length + " bytes)");
            } else {
                System.out.println("Closing stream. (not compressed, size: " + this.origSize + " bytes)");
            }
        }
        this.response.addHeader("Content-Length", Integer.toString(bytes.length));
        if (compressed) {
            this.response.addHeader("Content-Encoding", "gzip");
        }
        this.initialBuffer = null;
        this.output.write(bytes);
        this.output.flush();
        this.output.close();
        this.closed = true;
        GZIPResponseWrapper.RequestListener requestListener = this.gzipResponseWrapper.getRequestListener();
        if (requestListener != null) {
            requestListener.afterCommitResponse(bytes.length);
        }
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Cannot flush a closed output stream");
        }
        if (this.gzipstream != null) {
            this.gzipstream.flush();
        }
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        if (this.origSize + (long)len < (long)this.minimumSize) {
            this.initialBuffer.write(b, off, len);
        } else {
            if (this.initialBuffer != null) {
                this.baos = new ByteArrayOutputStream();
                this.gzipstream = new GZIPOutputStream(this.baos);
                this.gzipstream.write(this.initialBuffer.toByteArray(), off, (int)this.origSize);
                this.initialBuffer = null;
            }
            this.gzipstream.write(b, off, len);
        }
        this.origSize += (long)len;
    }

    public boolean closed() {
        return this.closed;
    }
}

