/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.ws;

import br.com.sankhya.ws.GZIPResponseWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GZIPFilter
implements Filter {
    private boolean debug;
    private int minimumSize;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            String ae = request.getHeader("accept-encoding");
            String browser = request.getHeader("User-Agent").toUpperCase();
            if (browser.indexOf("MSIE") < 0 && ae != null && ae.indexOf("gzip") != -1) {
                if (this.debug) {
                    System.out.println("accept-encoding header found for request to " + request.getRequestURI());
                }
                GZIPResponseWrapper wrappedResponse = new GZIPResponseWrapper(response, this.debug, this.minimumSize);
                chain.doFilter(req, (ServletResponse)wrappedResponse);
                wrappedResponse.finishResponse();
                wrappedResponse.clean();
                return;
            }
            if (this.debug) {
                System.out.println("No accept-encoding header found for request to " + request.getRequestURI());
            }
        }
        chain.doFilter(req, res);
    }

    public void init(FilterConfig filterConfig) {
        String debugStr = filterConfig.getInitParameter("debug");
        this.debug = debugStr != null && new Boolean(debugStr) != false;
        String sizeStr = filterConfig.getInitParameter("minimumSize");
        int n = this.minimumSize = sizeStr == null ? 0 : new Integer(sizeStr);
        if (this.debug) {
            System.out.println("Minimum size required to start using gzip is " + this.minimumSize + " bytes");
        }
    }

    public void destroy() {
    }
}

