/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.http;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpException;

public class ServerUtil {
    public static final String CHARACTER_SET = "ISO-8859-1";
    public static final Map contentTypePorExtencao = new HashMap();
    public static final String DEFAULT_CONTENT_TYPE = ".html";
    public static final String NOME_ARQUIVO_ERRO_ARQUIVO_NAO_EXISTE = "ERRO_ARQ_NAO_EXISTE";
    public static final String NOME_ARQUIVO_ERRO_ACESSO_NEGADO = "ERRO_ARQ_ACESSO_NEGADO";
    public static final int TAMANHO_MAX_ARQUIVO_ERRO = 2048;
    public static final String NAME_SESSION_ID = "SNKSESSION";

    static {
        contentTypePorExtencao.put(".swf", "application/x-shockwave-flash");
        contentTypePorExtencao.put(DEFAULT_CONTENT_TYPE, "text/html");
        contentTypePorExtencao.put(".htm", "text/html");
        contentTypePorExtencao.put(".zip", "application/octet-stream");
        contentTypePorExtencao.put(".ico", "image/x-ico");
        contentTypePorExtencao.put(".xml", "text/xml");
    }

    public static String getContentType(String fileName) {
        String contentType = null;
        int pos = fileName.lastIndexOf(".");
        if (pos > 0) {
            String ext = fileName.substring(pos);
            contentType = (String)contentTypePorExtencao.get(ext);
        } else {
            contentType = (String)contentTypePorExtencao.get(DEFAULT_CONTENT_TYPE);
        }
        return contentType;
    }

    public static String getErrorTemplate(String nomeArquivo, String param) throws Exception {
        File errorFile = new File("erros", nomeArquivo);
        if (errorFile.exists()) {
            int b;
            FileInputStream fin = new FileInputStream(errorFile);
            byte[] bytes = new byte[2048];
            int pos = 0;
            while ((b = fin.read()) > -1) {
                bytes[pos++] = (byte)b;
                if (pos <= 2048) continue;
                System.out.println("Erro: tamanho m\u00e1ximo para arquivo de erro atingido.");
                return null;
            }
            String ret = new String(bytes);
            if (ret.indexOf("_{MARK}_") == -1) {
                System.out.println("Marca\u00e7\u00e3o n\u00e3o existe no tamplate");
            }
            return ret;
        }
        return null;
    }

    public static void throwMe(Exception e) throws HttpException {
        HttpException hte = new HttpException(e.getMessage());
        hte.initCause((Throwable)e);
        throw hte;
    }

    public static String getTargetUri(String uri) {
        int pos = uri.indexOf(63);
        if (pos < 0) {
            return uri;
        }
        return uri.substring(0, pos);
    }
}

