/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.http;

import br.com.sankhya.http.HttpSessionAdapter;
import br.com.sankhya.http.HttpSessionInvalidateListener;
import com.sankhya.util.UIDGenerator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class HttpSession
extends HttpSessionAdapter
implements Serializable {
    private long creationTime;
    private long expireTime;
    private Map attributes = new HashMap();
    private String id;
    private HttpSessionInvalidateListener invalidateListener;
    private boolean newSession;

    public HttpSession(HttpSessionInvalidateListener invalidateListener) {
        this.creationTime = System.currentTimeMillis();
        this.expireTime = this.creationTime + 1800000L;
        this.id = UIDGenerator.getNextID();
        this.invalidateListener = invalidateListener;
        this.newSession = true;
    }

    public void updateExpireTime() {
        this.expireTime = System.currentTimeMillis() + 1800000L;
        this.setNewSession(false);
    }

    @Override
    public void setAttribute(String nome, Object att) {
        this.attributes.put(nome, att);
    }

    public Object getAtribute(String nome) {
        return this.attributes.get(nome);
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    @Override
    public void invalidate() {
        this.invalidateListener.invalidate(this);
    }

    public boolean isNewSession() {
        return this.newSession;
    }

    public void setNewSession(boolean newSession) {
        this.newSession = newSession;
    }
}

