/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.http;

import br.com.sankhya.http.HttpFileHandler;
import br.com.sankhya.http.HttpFilesystem;
import br.com.sankhya.http.HttpListener;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerRegistry;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class HttpServer
implements Runnable {
    public static final String ERROR_PAGE_ATT_NAME = "errorPage";
    private static Logger log = Logger.getLogger((String)HttpServer.class.getName());
    private HttpParams params;
    private HttpRequestHandler httpHandler;
    private ServerSocket serversocket;
    private boolean keepHttpSession;
    private String htmlErrorPage;

    public HttpServer(int port) throws Exception {
        this(port, true);
    }

    public HttpServer(int port, boolean keepHttpSesion) throws Exception {
        try {
            this.serversocket = new ServerSocket(port);
            this.params = new BasicHttpParams();
            this.params.setIntParameter("http.socket.timeout", 5000).setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", (Object)"HttpComponents/1.1");
            this.keepHttpSession = keepHttpSesion;
            File fileLogConf = new File("conf/log4j.conf");
            if (fileLogConf.exists()) {
                PropertyConfigurator.configure((String)"conf/log4j.conf");
            }
            this.httpHandler = new HttpFileHandler(this.keepHttpSession);
        }
        catch (BindException be) {
            Exception e = new Exception("Erro ao iniciar o http server. Poss\u00edvel causa: Porta: " + port + " em uso");
            e.initCause(be);
            throw e;
        }
        catch (IOException e) {
            RuntimeException rt = new RuntimeException(e.getMessage());
            rt.initCause(e);
            throw rt;
        }
    }

    public void addListener(String pattern, HttpListener listener) {
        ((HttpFileHandler)this.httpHandler).addListener(pattern, listener);
    }

    public static void main(String[] args) throws Exception {
        HttpServer httpServer = new HttpServer(9090);
        HttpFilesystem fileSystem = new HttpFilesystem("d:/temp");
        httpServer.addListener(".html", fileSystem);
        httpServer.addListener(".htm", fileSystem);
        Thread threadServer = new Thread((Runnable)httpServer, "HttpServer");
        threadServer.setDaemon(false);
        threadServer.start();
    }

    public void removeListener(String pattern) {
        ((HttpFileHandler)this.httpHandler).removeListener(pattern);
    }

    public void close() {
        try {
            this.serversocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        log.info((Object)("Aguardando na porta: " + this.serversocket.getLocalPort()));
        while (!Thread.interrupted()) {
            try {
                Socket socket = this.serversocket.accept();
                DefaultHttpServerConnection conn = new DefaultHttpServerConnection();
                log.info((Object)("Conex\u00e3o de: " + socket.getInetAddress()));
                conn.bind(socket, this.params);
                BasicHttpProcessor httpproc = new BasicHttpProcessor();
                httpproc.addInterceptor((HttpResponseInterceptor)new ResponseDate());
                httpproc.addInterceptor((HttpResponseInterceptor)new ResponseServer());
                httpproc.addInterceptor((HttpResponseInterceptor)new ResponseContent());
                httpproc.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
                HttpRequestHandlerRegistry reqistry = new HttpRequestHandlerRegistry();
                reqistry.register("*", this.httpHandler);
                HttpService httpService = new HttpService((HttpProcessor)httpproc, (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpResponseFactory)new DefaultHttpResponseFactory());
                httpService.setParams(this.params);
                httpService.setHandlerResolver((HttpRequestHandlerResolver)reqistry);
                WorkerThread t = new WorkerThread(httpService, (HttpServerConnection)conn);
                t.setDaemon(true);
                t.start();
            }
            catch (InterruptedIOException ex) {
                break;
            }
            catch (IOException e) {
                System.err.println("I/O error initialising connection thread: " + e.getMessage());
                break;
            }
        }
    }

    public Properties getDefaultLogProperties() {
        Properties logProp = new Properties();
        logProp.put("log4j.rootLogger", "INFO, arquivo");
        logProp.put("log4j.logger.br.com.sankhya.http", "debug, console");
        logProp.put("log4j.appender.console", "org.apache.log4j.ConsoleAppender");
        logProp.put("log4j.appender.console.layout", "org.apache.log4j.PatternLayout");
        logProp.put("log4j.appender.console.layout.ConversionPattern", "%d %p (%F:%L) [%M] %x - %m%n");
        logProp.put("log4j.appender.arquivo", "org.apache.log4j.FileAppender");
        logProp.put("log4j.appender.arquivo.File", "log/httpserver.log");
        logProp.put("log4j.appender.arquivo.Append", "false");
        logProp.put("log4j.appender.arquivo.layout", "org.apache.log4j.PatternLayout");
        logProp.put("log4j.appender.arquivo.layout.ConversionPattern", "%d %p (%F:%L) [%M] %x - %m%n");
        return logProp;
    }

    public String getHtmlErrorPage() {
        return this.htmlErrorPage;
    }

    public void setHtmlErrorPage(String htmlErrorPage) {
        this.htmlErrorPage = htmlErrorPage;
    }

    static /* synthetic */ String access$0(HttpServer httpServer) {
        return httpServer.htmlErrorPage;
    }

    class WorkerThread
    extends Thread {
        private final HttpServerConnection conn;
        private final HttpService httpservice;

        public WorkerThread(HttpService httpservice, HttpServerConnection conn) {
            this.httpservice = httpservice;
            this.conn = conn;
        }

        /*
         * Unable to fully structure code
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            context = new BasicHttpContext(null);
            if (HttpServer.access$0(HttpServer.this) == null) ** GOTO lbl9
            context.setAttribute("errorPage", (Object)HttpServer.access$0(HttpServer.this));
            try {
                try {
                    if (true) ** GOTO lbl9
                    do {
                        this.httpservice.handleRequest(this.conn, (HttpContext)context);
lbl9:
                        // 3 sources

                        if (Thread.interrupted()) return;
                    } while (this.conn.isOpen());
                    return;
                }
                catch (ConnectionClosedException ex) {
                    System.err.println("Client closed connection");
                    try {
                        this.conn.shutdown();
                        return;
                    }
                    catch (IOException var4_5) {}
                    return;
                }
                catch (IOException ex) {
                    System.err.println("I/O error: " + ex.getMessage());
                    try {
                        this.conn.shutdown();
                        return;
                    }
                    catch (IOException var4_6) {}
                    return;
                }
                catch (HttpException ex) {
                    System.err.println("Unrecoverable HTTP protocol violation: " + ex.getMessage());
                    {
                        catch (Throwable var3_10) {
                            throw var3_10;
                        }
                    }
                    try {
                        this.conn.shutdown();
                        return;
                    }
                    catch (IOException var4_7) {}
                    return;
                }
            }
            finally {
                try {
                    this.conn.shutdown();
                }
                catch (IOException var4_9) {}
            }
        }
    }
}

