/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.message.BasicHeader;

public class HttpResponse {
    private ByteArrayOutputStream byteOutputStream;
    private org.apache.http.HttpResponse httpResponse;
    private String contentType;

    public HttpResponse(org.apache.http.HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
        this.byteOutputStream = new ByteArrayOutputStream();
    }

    public void write(String s) throws IOException {
        this.byteOutputStream.write(s.getBytes());
    }

    public void write(byte[] b) throws IOException {
        this.byteOutputStream.write(b);
    }

    public void setStatusCode(int arg0) throws IllegalStateException {
        this.httpResponse.setStatusCode(arg0);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setEntity(HttpEntity httpEntity) {
        if (this.byteOutputStream.size() > 0) {
            throw new IllegalStateException("Existem bytes no buffer de grava\u00e7\u00e3o.");
        }
        this.httpResponse.setEntity(httpEntity);
    }

    public void flushBytes() {
        if (this.byteOutputStream.size() > 0) {
            EntityTemplate body = new EntityTemplate(new ContentProducer(){

                public void writeTo(OutputStream outstream) throws IOException {
                    outstream.write(HttpResponse.this.byteOutputStream.toByteArray());
                    outstream.flush();
                }
            });
            body.setContentType(this.contentType);
            this.httpResponse.setEntity((HttpEntity)body);
        }
    }

    public void setHeader(Header header) {
        this.httpResponse.setHeader(header);
    }

    public void setHeader(String name, String value) {
        this.httpResponse.setHeader((Header)new BasicHeader(name, value));
    }

    public void addHeader(String name, String value) {
        this.httpResponse.addHeader((Header)new BasicHeader(name, value));
    }

    public OutputStream getOutputStream() {
        return this.byteOutputStream;
    }
}

