/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.http;

import br.com.sankhya.http.HttpServletRequestAdapter;
import br.com.sankhya.http.HttpSession;
import br.com.sankhya.http.ServletInputStreamImpl;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.http.Header;
import org.apache.http.params.HttpParams;

public class HttpRequest
extends HttpServletRequestAdapter {
    private Map params;
    private HttpParams httpParams;
    private org.apache.http.HttpRequest httpRequest;
    private Map fileItens;
    private HttpSession session;
    private ServletInputStream inputStream;

    public HttpRequest(org.apache.http.HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
        this.httpParams = httpRequest.getParams();
        this.params = new HashMap();
        this.fileItens = new HashMap();
    }

    @Override
    public String getParameter(String paramName) {
        String param = (String)this.params.get(paramName);
        if (param == null) {
            param = (String)this.httpParams.getParameter(paramName);
        }
        return param;
    }

    public FileItem getFileItem(String fieldName) {
        return (FileItem)this.fileItens.get(fieldName);
    }

    public void addFileItem(FileItem f) {
        this.fileItens.put(f.getFieldName(), f);
    }

    public org.apache.http.HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public void addParameter(String name, String value) {
        this.params.put(name, value);
    }

    @Override
    public HttpSession getSession() {
        if (this.session == null) {
            throw new IllegalStateException("Sess\u00e3o n\u00e3o inicializada");
        }
        return this.session;
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    @Override
    public ServletInputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = new ServletInputStreamImpl(inputStream);
    }

    public Collection getFiles() {
        return this.fileItens.values();
    }

    @Override
    public String getHeader(String header) {
        Header[] headers = this.httpRequest.getHeaders(header);
        if (headers != null && headers.length != 0) {
            return headers[0].getValue();
        }
        return null;
    }

    @Override
    public int getContentLength() {
        String content = this.getHeader("Content-Length");
        if (content != null) {
            return Integer.parseInt(content);
        }
        return 0;
    }

    @Override
    public Enumeration getHeaderNames() {
        return new EnumHeaders(this.httpRequest.getAllHeaders());
    }

    public static class EnumHeaders
    implements Enumeration<String> {
        private Header[] headers;
        private int pos;
        private int size;

        private EnumHeaders(Header[] headers) {
            if (headers == null) {
                throw new RuntimeException("Headers null");
            }
            this.headers = headers;
            this.pos = 0;
            this.size = headers.length;
        }

        @Override
        public boolean hasMoreElements() {
            return this.pos != this.size;
        }

        @Override
        public String nextElement() {
            return this.headers[this.pos++].getName();
        }
    }
}

