/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.http;

import br.com.sankhya.http.HttpListener;
import br.com.sankhya.http.HttpRequest;
import br.com.sankhya.http.HttpResponse;
import br.com.sankhya.http.ServerUtil;
import java.io.File;
import java.net.URLDecoder;
import org.apache.http.HttpEntity;
import org.apache.http.entity.FileEntity;
import org.apache.log4j.Logger;

public class HttpFilesystem
implements HttpListener {
    private String docRoot;
    private static Logger log = Logger.getLogger((String)HttpFilesystem.class.getName());

    public HttpFilesystem(String docRoot) {
        this.docRoot = docRoot;
    }

    @Override
    public void processRequest(HttpRequest requestParam, HttpResponse response) throws Exception {
        org.apache.http.HttpRequest request = requestParam.getHttpRequest();
        String target = ServerUtil.getTargetUri(request.getRequestLine().getUri());
        File file = new File(this.docRoot, URLDecoder.decode(target));
        if (!file.exists()) {
            response.setStatusCode(404);
            String templateError = null;
            try {
                templateError = ServerUtil.getErrorTemplate("ERRO_ARQ_NAO_EXISTE", file.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (templateError != null) {
                response.write(templateError);
            } else {
                response.write("<html><body><h1>");
                response.write("Arquivo ");
                response.write(file.getName());
                response.write(" n\u00e3o encontrado.");
                response.write("</h1></body></html>");
            }
        } else if (!file.canRead() || file.isDirectory()) {
            response.setStatusCode(403);
            String templateError = null;
            try {
                templateError = ServerUtil.getErrorTemplate("ERRO_ARQ_ACESSO_NEGADO", file.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (templateError != null) {
                response.write(templateError);
            } else {
                response.write("<html><body><h1>");
                response.write("Acesso negado");
                response.write("</h1></body></html>");
            }
        } else {
            response.setStatusCode(200);
            FileEntity body = new FileEntity(file, ServerUtil.getContentType(file.getAbsolutePath()));
            response.setEntity((HttpEntity)body);
            log.debug((Object)("Serving file " + file.getPath()));
        }
    }
}

