/*
 * Decompiled with CFR 0.152.
 */
package br.com.sankhya.http;

import br.com.sankhya.http.HttpListener;
import br.com.sankhya.http.HttpRequest;
import br.com.sankhya.http.HttpResponse;
import br.com.sankhya.http.HttpSession;
import br.com.sankhya.http.HttpSessionInvalidateListener;
import br.com.sankhya.http.ServerUtil;
import br.com.sankhya.http.fileupload.HttpcoreFileUpload;
import br.com.sankhya.http.fileupload.RequestContextImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.log4j.Logger;

public class HttpFileHandler
implements HttpRequestHandler {
    private static Logger log = Logger.getLogger((String)HttpFileHandler.class.getName());
    private HttpSessionInvalidateListener invalidateListener;
    private Map httpSessions = new HashMap();
    private Map listeners = new LinkedHashMap();
    private boolean keepHttpSesion;

    public HttpFileHandler(boolean keepHttpSesion) {
        this.invalidateListener = new SessionInvalidate();
        this.keepHttpSesion = keepHttpSesion;
        Thread threadSessionManager = new Thread((Runnable)new HttpSessionManager(), "HttpSessionManager");
        threadSessionManager.setDaemon(true);
        threadSessionManager.start();
    }

    public void addListener(String pattern, HttpListener listener) {
        this.listeners.put(pattern, listener);
    }

    public void handle(org.apache.http.HttpRequest request, org.apache.http.HttpResponse response, HttpContext context) throws HttpException, IOException {
        String method = request.getRequestLine().getMethod().toUpperCase();
        if (!(method.equals("GET") || method.equals("HEAD") || method.equals("POST"))) {
            throw new MethodNotSupportedException(String.valueOf(method) + " method not supported");
        }
        String target = request.getRequestLine().getUri();
        log.info((Object)("target: " + target));
        if ("/favicon.ico".equals(target)) {
            this.writeFiveIcon(response);
        } else {
            HttpRequest httpRequest = new HttpRequest(request);
            HttpResponse httpResponse = new HttpResponse(response);
            this.initOrSetSession(httpRequest, httpResponse);
            if (method.equals("POST")) {
                HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
                boolean isMultPart = FileUploadBase.isMultipartContent((RequestContext)new RequestContextImpl(entity));
                if (isMultPart) {
                    HttpcoreFileUpload fup = new HttpcoreFileUpload((FileItemFactory)new DiskFileItemFactory());
                    try {
                        List files = fup.parseRequest(entity);
                        for (FileItem fileItem : files) {
                            if (!fileItem.isFormField()) {
                                log.info((Object)(String.valueOf(fileItem.isFormField()) + " " + fileItem.getName() + " : " + fileItem.getSize()));
                                httpRequest.addFileItem(fileItem);
                                continue;
                            }
                            httpRequest.addParameter(fileItem.getFieldName(), fileItem.getString());
                            log.debug((Object)(String.valueOf(fileItem.getFieldName()) + "=" + fileItem.getString()));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new HttpException(e.getMessage());
                    }
                } else {
                    String contentType = this.getHeader("Content-type", request);
                    log.info((Object)("Content-type: " + contentType));
                    if (contentType != null && contentType.indexOf("application/x-www-form") >= 0) {
                        int tam = (int)entity.getContentLength();
                        if (tam > 0) {
                            byte[] contentBytes = new byte[tam];
                            InputStream input = entity.getContent();
                            int b = 0;
                            int i = 0;
                            while ((b = input.read()) != -1) {
                                contentBytes[i++] = (byte)b;
                            }
                            httpRequest.setInputStream(new ByteArrayInputStream(contentBytes));
                            String content = new String(contentBytes);
                            this.parseAndAddPostParam(httpRequest, content);
                        }
                    } else {
                        httpRequest.setInputStream(entity.getContent());
                    }
                }
                this.parseAndAddGetParam(httpRequest);
            } else if (method.equals("GET")) {
                this.parseAndAddGetParam(httpRequest);
            }
            HttpListener httpListener = this.getListener(target);
            if (httpListener == null) {
                String errorPage = (String)context.getAttribute("errorPage");
                if (errorPage != null) {
                    byte[] b = errorPage.getBytes();
                    httpResponse.setContentType("text/html");
                    httpResponse.getOutputStream().write(b);
                    httpResponse.flushBytes();
                    return;
                }
                throw new HttpException("N\u00e3o foi poss\u00edvel encontrar o listener para o recurso solicitado.");
            }
            try {
                httpListener.processRequest(httpRequest, httpResponse);
                httpResponse.flushBytes();
                if (!this.keepHttpSesion) {
                    httpRequest.getSession().invalidate();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ServerUtil.throwMe(e);
            }
        }
    }

    public void removeListener(String pattern) {
        this.listeners.remove(pattern);
    }

    private Header createCookieSessionHeader(HttpSession session) {
        StringBuffer buf = new StringBuffer();
        buf.append("SNKSESSION").append('=').append(session.getId());
        buf.append("; Path=/");
        BasicHeader header = new BasicHeader("Set-Cookie", buf.toString());
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpSession createSession(HttpResponse response) {
        HttpSession session = new HttpSession(this.invalidateListener);
        response.setHeader(this.createCookieSessionHeader(session));
        Map map = this.httpSessions;
        synchronized (map) {
            this.httpSessions.put(session.getId(), session);
            this.httpSessions.notifyAll();
        }
        return session;
    }

    private String getHeader(String headerName, org.apache.http.HttpRequest request) {
        Header[] headers = request.getHeaders(headerName);
        if (headers.length > 0) {
            return headers[0].getValue();
        }
        return null;
    }

    private HttpListener getListener(String targetResource) {
        int posPonto = targetResource.indexOf(46);
        String resourcePart = null;
        if (posPonto < 0) {
            int posInt = targetResource.indexOf(63);
            if (posInt < 0) {
                return null;
            }
            resourcePart = targetResource.substring(1, posInt);
        } else {
            int posFim = targetResource.indexOf(63);
            if (posFim < 0) {
                posFim = targetResource.length();
            }
            if (posFim > posPonto) {
                resourcePart = targetResource.substring(posPonto, posFim);
            }
        }
        HttpListener listener = null;
        if (resourcePart != null) {
            listener = (HttpListener)this.listeners.get(resourcePart);
        }
        return listener;
    }

    private String getSessionFromCookie(HttpRequest request) {
        Header[] headers = request.getHttpRequest().getHeaders("Cookie");
        if (headers != null && headers.length > 0) {
            int i = 0;
            while (i < headers.length) {
                Header header = headers[i];
                StringTokenizer token = new StringTokenizer(header.getValue(), ";");
                while (token.hasMoreElements()) {
                    String[] nomeValor;
                    String cookieParam = token.nextToken();
                    if (cookieParam.indexOf("SNKSESSION") < 0 || (nomeValor = cookieParam.split("=")).length != 2) continue;
                    return nomeValor[1];
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOrSetSession(HttpRequest request, HttpResponse response) {
        String sessionId = this.getSessionFromCookie(request);
        HttpSession session = null;
        if (sessionId == null) {
            session = this.createSession(response);
        } else {
            Map map = this.httpSessions;
            synchronized (map) {
                session = (HttpSession)this.httpSessions.get(sessionId);
                if (session == null) {
                    session = this.createSession(response);
                } else {
                    request.setSession(session);
                    session.updateExpireTime();
                }
                this.httpSessions.notifyAll();
            }
        }
        request.setSession(session);
    }

    private void parseAndAddGetParam(HttpRequest httpRequest) throws UnsupportedEncodingException {
        String uri = httpRequest.getHttpRequest().getRequestLine().getUri();
        int pos = uri.indexOf(63);
        if (pos >= 0) {
            String parans = uri.substring(pos + 1, uri.length());
            parans = URLDecoder.decode(parans, "UTF-8");
            this.parseAndAddPostParam(httpRequest, parans);
        }
    }

    private void parseAndAddPostParam(HttpRequest httpRequest, String parans) {
        StringTokenizer token = new StringTokenizer(parans, "&");
        while (token.hasMoreElements()) {
            String nameValue = token.nextToken();
            int posIgual = nameValue.indexOf(61);
            if (posIgual <= 0) continue;
            String rpName = nameValue.substring(0, posIgual);
            String rpValue = nameValue.substring(posIgual + 1);
            httpRequest.addParameter(rpName, rpValue);
            log.info((Object)("Param: " + rpName + "=" + rpValue));
        }
    }

    private void writeFiveIcon(org.apache.http.HttpResponse response) {
        response.setStatusCode(200);
        EntityTemplate body = new EntityTemplate(new ContentProducer(){

            public void writeTo(OutputStream outstream) throws IOException {
                int b;
                InputStream input = this.getClass().getResourceAsStream("/br/com/sankhya/http/resources/logoSK.ico");
                while ((b = input.read()) >= 0) {
                    outstream.write(b);
                }
                outstream.flush();
            }
        });
        body.setContentType(ServerUtil.getContentType("fiveicon.ico"));
        response.setEntity((HttpEntity)body);
    }

    public class HttpSessionManager
    implements Runnable {
        private static final long SLEEP_TIME = 60000L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.interrupted()) {
                Map map = HttpFileHandler.this.httpSessions;
                synchronized (map) {
                    long now = System.currentTimeMillis();
                    ArrayList<HttpSession> toRemove = new ArrayList<HttpSession>();
                    for (HttpSession session : HttpFileHandler.this.httpSessions.values()) {
                        if (session.isNewSession() || now <= session.getExpireTime()) continue;
                        toRemove.add(session);
                    }
                    for (HttpSession session : toRemove) {
                        session.invalidate();
                    }
                    HttpFileHandler.this.httpSessions.notifyAll();
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public class SessionInvalidate
    implements HttpSessionInvalidateListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidate(HttpSession session) {
            log.info((Object)("invalidando sess\u00e3o: " + session.getId()));
            Map map = HttpFileHandler.this.httpSessions;
            synchronized (map) {
                HttpFileHandler.this.httpSessions.remove(session.getId());
                HttpFileHandler.this.httpSessions.notifyAll();
            }
        }
    }
}

